/*
 * Decompiled with CFR 0.152.
 */
package com.peergine.plugin.android;

import android.media.AudioTrack;
import android.os.Handler;
import android.util.Log;
import com.peergine.plugin.android.pgSysAudioHandler;
import com.peergine.plugin.android.pgSysAudioIn;
import com.peergine.plugin.android.pgSysJNI;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public class pgSysAudioOut
implements AudioTrack.OnPlaybackPositionUpdateListener {
    private int m_iID = 0;
    private AudioTrack m_Player = null;
    private AtomicInteger m_atomicPlayer = new AtomicInteger();
    private boolean m_bInputPollCallback = false;
    private int m_iSampleByte = 0;
    private int m_iSampleRate = 0;
    private int m_iBufSize = 0;
    private int m_iPackSize = 0;
    private int m_iUsedSize = 0;
    private int m_iPackInterval = 0;
    private long m_lCallbackStamp = 0L;
    private int m_iCallbackPos = 0;
    private int m_iCallbackCount = 0;
    private pgSysAudioIn.OutCallback m_outCallback = new pgSysAudioIn.OutCallback(){

        @Override
        public boolean OnPoll() {
            return pgSysAudioOut.this.OnPollProc();
        }
    };

    public pgSysAudioOut(int iID) {
        this.m_iID = iID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int Open(int uSampleBits, int uSampleRate, int uChannels, int uPackBytes) {
        Log.d((String)"pgnpp", (String)("pgSysAudioOut.Open, uSampleBits=" + uSampleBits + ", uSampleRate=" + uSampleRate + ", uPackBytes=" + uPackBytes));
        try {
            int iSampleFmt = uSampleBits == 16 ? 2 : 3;
            int iMinBufSize = AudioTrack.getMinBufferSize((int)uSampleRate, (int)4, (int)iSampleFmt);
            if (iMinBufSize <= 0) {
                Log.d((String)"pgnpp", (String)"pgSysAudioOut.Open failed. get min buffer size");
                return 0;
            }
            Log.d((String)"pgnpp", (String)("pgSysAudioOut.Open, iMinBufSize=" + iMinBufSize));
            int iBufSize = iMinBufSize / uPackBytes * uPackBytes;
            if (iMinBufSize % uPackBytes != 0) {
                iBufSize += uPackBytes;
            }
            if (iBufSize / uPackBytes < 3) {
                iBufSize = uPackBytes * 3;
            }
            this.m_iSampleByte = uSampleBits / 8;
            this.m_iSampleRate = uSampleRate;
            this.m_iBufSize = iBufSize;
            this.m_iPackSize = uPackBytes;
            this.m_iUsedSize = 0;
            this.m_iPackInterval = 1000 * (uPackBytes / this.m_iSampleByte) / uSampleRate;
            this.m_lCallbackStamp = 0L;
            this.m_iCallbackPos = 0;
            this.m_iCallbackCount = 0;
            if (pgSysAudioIn.IsInputOpened()) {
                this.m_Player = new AudioTrack(3, uSampleRate, 4, 2, iBufSize, 1);
                if (this.m_Player.getState() != 1) {
                    Log.d((String)"pgnpp", (String)"pgSysAudioOut.Open failed, not inited");
                    return 0;
                }
                this.m_Player.play();
                pgSysAudioIn.SetOutCallback(this.m_outCallback);
                this.m_bInputPollCallback = true;
                Log.d((String)"pgnpp", (String)"pgSysAudioOut.Open: input poll mode.");
            } else {
                Handler handler = pgSysAudioHandler.OutputHandlerGet();
                if (handler == null) {
                    Log.d((String)"pgnpp", (String)"pgSysAudioOut.Open failed, get handler");
                    return 0;
                }
                this.m_Player = new AudioTrack(3, uSampleRate, 4, 2, iBufSize, 1);
                if (this.m_Player.getState() != 1) {
                    pgSysAudioHandler.OutputHandlerRelease();
                    Log.d((String)"pgnpp", (String)"pgSysAudioOut.Open failed, not inited");
                    return 0;
                }
                if (this.m_Player.setPositionNotificationPeriod(uPackBytes / (uSampleBits / 8)) != 0) {
                    pgSysAudioHandler.OutputHandlerRelease();
                    Log.d((String)"pgnpp", (String)"pgSysAudioOut.Open failed. set pos notify");
                    return 0;
                }
                this.m_Player.setPlaybackPositionUpdateListener((AudioTrack.OnPlaybackPositionUpdateListener)this, handler);
                this.m_Player.play();
                this.m_bInputPollCallback = false;
                Log.d((String)"pgnpp", (String)"pgSysAudioOut.Open: thread handler mode.");
            }
            pgSysJNI.AudioOutOnOpen(this.m_iID);
            Log.d((String)"pgnpp", (String)"pgSysAudioOut.Open: ok");
            return 1;
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysAudioOut.Open: ex=" + ex.toString()));
            return 0;
        }
    }

    public void Close() {
        try {
            Log.d((String)"pgnpp", (String)"pgSysAudioOut.Close");
            if (this.m_bInputPollCallback) {
                pgSysAudioIn.SetOutCallback(null);
                if (this.m_Player != null) {
                    this.m_Player.stop();
                    this.m_Player.release();
                    this.m_Player = null;
                }
            } else if (this.m_Player != null) {
                this.m_Player.setPlaybackPositionUpdateListener(null);
                this.m_Player.stop();
                this.m_Player.release();
                this.m_Player = null;
                pgSysAudioHandler.OutputHandlerRelease();
            }
            pgSysJNI.AudioOutOnClose(this.m_iID);
            Log.d((String)"pgnpp", (String)"pgSysAudioOut.Close: finish");
        }
        catch (Exception ex) {
            pgSysJNI.AudioOutOnClose(this.m_iID);
            Log.d((String)"pgnpp", (String)("pgSysAudioOut.Close: ex=" + ex.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int Write(byte[] byteData, int iSize) {
        try {
            int iWrite = -1;
            AtomicInteger atomicInteger = this.m_atomicPlayer;
            synchronized (atomicInteger) {
                if (this.m_iBufSize - this.m_iUsedSize >= this.m_iPackSize && (iWrite = this.m_Player.write(byteData, 0, iSize)) > 0) {
                    if (this.m_bInputPollCallback && this.m_iUsedSize <= 0) {
                        this.m_lCallbackStamp = new Date().getTime() + (long)this.m_iPackInterval;
                        this.m_iCallbackPos = this.m_Player.getPlaybackHeadPosition();
                        this.m_iCallbackCount = 0;
                    }
                    this.m_iUsedSize += this.m_iPackSize;
                    if (iWrite != iSize) {
                        Log.d((String)"pgnpp", (String)("pgSysAudioOut.Write: iWrite=" + iWrite + ", iSize=" + iSize));
                    }
                }
            }
            return iWrite;
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysAudioOut.Write: ex=" + ex.toString()));
            return -1;
        }
    }

    public int GetDelay() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean OnPollProc() {
        try {
            boolean bCallback = false;
            AtomicInteger atomicInteger = this.m_atomicPlayer;
            synchronized (atomicInteger) {
                long lCurStamp;
                if (this.m_iUsedSize >= this.m_iPackSize && (lCurStamp = new Date().getTime()) - this.m_lCallbackStamp >= (long)this.m_iPackInterval) {
                    int iCurPos;
                    ++this.m_iCallbackCount;
                    if (this.m_iCallbackCount % 100 == 0 && (iCurPos = this.m_Player.getPlaybackHeadPosition()) > this.m_iCallbackPos) {
                        int iInterval = 1000 * ((iCurPos - this.m_iCallbackPos) / this.m_iCallbackCount) / this.m_iSampleRate;
                        if (iInterval > this.m_iPackInterval && this.m_iPackInterval < 43) {
                            ++this.m_iPackInterval;
                        } else if (iInterval < this.m_iPackInterval && this.m_iPackInterval > 37) {
                            --this.m_iPackInterval;
                        }
                    }
                    this.m_lCallbackStamp += (long)this.m_iPackInterval;
                    this.m_iUsedSize -= this.m_iPackSize;
                    bCallback = true;
                }
            }
            if (bCallback) {
                pgSysJNI.AudioOutOnPlayed(this.m_iID);
            }
            return bCallback;
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysAudioOut.OnPollProc: ex=" + ex.toString()));
            return true;
        }
    }

    public void onMarkerReached(AudioTrack track) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPeriodicNotification(AudioTrack track) {
        block6: {
            try {
                if (this.m_Player == null) break block6;
                AudioTrack audioTrack = this.m_Player;
                synchronized (audioTrack) {
                    if (this.m_iUsedSize >= this.m_iPackSize) {
                        this.m_iUsedSize -= this.m_iPackSize;
                    }
                }
                pgSysJNI.AudioOutOnPlayed(this.m_iID);
            }
            catch (Exception ex) {
                Log.d((String)"pgnpp", (String)("pgSysAudioOut.onPeriodicNotification: ex=" + ex.toString()));
            }
        }
    }
}

