/*
 * Decompiled with CFR 0.152.
 */
package com.peergine.plugin.android;

import android.util.Log;
import com.peergine.plugin.android.pgSysJNI;
import com.peergine.plugin.android.pgSysWnd;

public class pgSysVideoIn {
    private int m_iID = 0;
    private int m_iPixBytes = 0;
    private int m_iWidth = 0;
    private int m_iHeight = 0;
    private int m_iFrmRate = 0;
    private int m_iFormat = -1;
    private int m_iRotate = 0;
    private int m_iCameraNo = 0;
    private int m_iRotateRes = 0;
    private int m_iCameraNoRes = 0;
    private int m_iFacing = -1;
    private pgSysWnd m_pluginView = null;
    private Runnable m_RunOpen = new Runnable(){

        @Override
        public void run() {
            Log.d((String)"pgnpp", (String)"pgSysVideoIn, Open run");
            if (pgSysVideoIn.this.m_pluginView != null) {
                pgSysVideoIn.this.m_pluginView.CameraOpen(pgSysVideoIn.this.m_iID, pgSysVideoIn.this.m_iPixBytes, pgSysVideoIn.this.m_iWidth, pgSysVideoIn.this.m_iHeight, pgSysVideoIn.this.m_iFrmRate, pgSysVideoIn.this.m_iRotate, pgSysVideoIn.this.m_iCameraNo);
            }
        }
    };
    private Runnable m_RunClose = new Runnable(){

        @Override
        public void run() {
            Log.d((String)"pgnpp", (String)"pgSysVideoIn, close run");
            if (pgSysVideoIn.this.m_pluginView != null) {
                pgSysVideoIn.this.m_pluginView.CameraClose();
            }
        }
    };

    public pgSysVideoIn(int iID) {
        Log.d((String)"pgnpp", (String)"pgSysVideoIn()");
        this.m_iID = iID;
    }

    public int Open(int iPixBytes, int iWidth, int iHeight, int iFrmRate, int iRotate, int iCameraNo, pgSysWnd pluginView) {
        block5: {
            block4: {
                Log.d((String)"pgnpp", (String)"pgSysVideoIn.Open");
                try {
                    this.m_iPixBytes = iPixBytes;
                    this.m_iWidth = iWidth;
                    this.m_iHeight = iHeight;
                    this.m_iFrmRate = iFrmRate;
                    this.m_iRotate = iRotate;
                    this.m_iCameraNo = iCameraNo;
                    this.m_pluginView = pluginView;
                    this.m_pluginView.CameraSetStatus(1, 0);
                    if (this.m_pluginView.PostRunnable(this.m_RunOpen, 0)) break block4;
                    Log.d((String)"pgnpp", (String)"pgSysVideoIn.Open: PostRunnable open failed");
                    return 0;
                }
                catch (Exception ex) {
                    Log.d((String)"pgnpp", (String)"pgSysVideoIn.Open Exception");
                    this.m_iFormat = -1;
                    return 0;
                }
            }
            int iStatus = this.CheckStatus(1, 100, 10000);
            if (iStatus > 0) break block5;
            this.m_pluginView.PostRunnable(this.m_RunClose, 0);
            Log.d((String)"pgnpp", (String)("pgSysVideoIn.Open: iStatus=" + iStatus));
            return 0;
        }
        this.m_iFormat = this.m_pluginView.CameraGetFormat();
        this.m_iRotateRes = this.m_pluginView.CameraGetRotate();
        this.m_iCameraNoRes = this.m_pluginView.CameraGetCameraNo();
        this.m_iFacing = this.m_pluginView.CameraGetFacing();
        pgSysJNI.VideoInOnOpen(this.m_iID);
        return 1;
    }

    public void Close() {
        Log.d((String)"pgnpp", (String)"pgSysVideoIn.Close");
        try {
            if (this.m_pluginView != null) {
                this.m_pluginView.CameraSetStatus(0, 0);
                if (this.m_pluginView.PostRunnable(this.m_RunClose, 0)) {
                    int iStatus = this.CheckStatus(0, 50, 1000);
                    if (iStatus < 0) {
                        Log.d((String)"pgnpp", (String)("pgSysVideoIn.Close: iStatus=" + iStatus));
                    }
                } else {
                    Log.d((String)"pgnpp", (String)"pgSysVideoIn.Close: PostRunnable close failed");
                }
            }
            pgSysJNI.VideoInOnClose(this.m_iID);
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)"pgSysVideoIn.Close Exception");
        }
        this.m_iFormat = -1;
    }

    public int GetFormat() {
        return this.m_iFormat;
    }

    public int GetRotate() {
        return this.m_iRotateRes;
    }

    public int GetCameraNo() {
        return this.m_iCameraNoRes;
    }

    public int GetFacing() {
        return this.m_iFacing;
    }

    private int CheckStatus(int iMethod, int iStep, int iTimeout) {
        int iStatus = -2;
        try {
            int iTryCount = iTimeout / iStep;
            int i = 0;
            while (i < iTryCount) {
                iStatus = this.m_pluginView.CameraGetStatus(iMethod);
                if (iStatus == 0) {
                    Thread.sleep(iStep);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysVideoIn.CheckStatus: ex=" + ex.toString()));
        }
        return iStatus;
    }
}

