package com.peergine.pghtml5bridge;

import android.annotation.SuppressLint;
import android.content.DialogInterface;
import android.os.Handler;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import static com.peergine.plugin.html5bridge.pgJniHtml5Bridge.PGHtml5BridgeStart;
import static com.peergine.plugin.html5bridge.pgJniHtml5Bridge.PGHtml5BridgeStop;
import static com.peergine.plugin.html5bridge.pgJniHtml5Bridge.PGHtml5BridgeVersion;
import static java.lang.Thread.sleep;

import com.peergine.plugin.android.pgSysCmn;

public class MainActivity extends AppCompatActivity {
    private WebView mWebView;
    private Handler mHandler = new Handler();

    @SuppressLint({"JavascriptInterface", "SetJavaScriptEnabled"})
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Log.d("pgH5bridge", "onCreate");

        String sVersion = PGHtml5BridgeVersion();
        Log.d("pgH5bridge", "onCreate: h5 version");
        //Toast.makeText(this, "PGHtml5BridgeVersion = " + sVersion, Toast.LENGTH_LONG).show();

        int iRet = PGHtml5BridgeStart("127.0.0.1", 17885, "", this);
        if (iRet == 0) {
            PGHtml5BridgeStop();
            iRet = PGHtml5BridgeStart("127.0.0.1", 17885, "", this);
            if (iRet == 0) {
                Toast.makeText(this, "PGHtml5BridgeStart ret = " + iRet, Toast.LENGTH_LONG).show();
            }
        }

        Log.d("pgH5bridge", "onCreate: h5 start");

        try {
            sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        mWebView = (WebView) findViewById(R.id.webview);
        WebSettings webSettings = mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);

        webSettings.setLoadWithOverviewMode(true);

        webSettings.setBuiltInZoomControls(true);// 设置WebView可触摸放大缩小
        webSettings.setUseWideViewPort(true);
        webSettings.setSupportZoom(true);

        mWebView.addJavascriptInterface(new Object() {
            public void clickOnAndroid() {
                mHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        mWebView.loadUrl("javascript:wave()");
                    }
                });
            }
        }, "demo");

        mWebView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Log.i("WebView", "Attempting to load URL: " + url);

                view.loadUrl(url);
                return true;
            }
        });

        mWebView.loadUrl("file:///android_asset/index.html");
    }

    public void onDestroy() {
        PGHtml5BridgeStop();
        super.onDestroy();
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if(keyCode==KeyEvent.KEYCODE_BACK)
        {
            if(mWebView.canGoBack())
            {
                mWebView.goBack();//返回上一页面
                return true;
            }
            else if(event.getRepeatCount() == 0)
            {
                Log.d("pgH5bridge", "onKeyDown, KEYCODE_BACK");
                ExitDialog();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);

    }

    private DialogInterface.OnClickListener m_DlgClick = new DialogInterface.OnClickListener() {
        public void onClick(DialogInterface dialog, int which) {
            if (which == AlertDialog.BUTTON_POSITIVE) {
                PGHtml5BridgeStop();
                android.os.Process.killProcess(android.os.Process.myPid());
            }
        }
    };
    public void ExitDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Confirm");
        builder.setMessage("Are you sure to exit?");
        builder.setPositiveButton("YES", m_DlgClick);
        builder.setNegativeButton("NO", m_DlgClick);
        builder.show();
    }

    public void Alert(String sTitle, String sMsg) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle(sTitle);
        builder.setMessage(sMsg);
        builder.setPositiveButton("OK", null);
        builder.show();
    }
}
