//
//  ViewController.m
//  pgHtml5BridgeApp
//
//  Created by ctkj-001 on 2018/6/21.
//  Copyright © 2018年 ctkj-001. All rights reserved.
//

#import "ViewController.h"
#import "pgDybHtml5Bridge/pgIOSHtml5Bridge.h"

void LogOutputCB(unsigned int nLevel, const char* sLogOut)
{
    NSLog(@"%d : %s", nLevel ,sLogOut);
}

void pg_signal(int signum)
{
}

@interface ViewController()
@property (weak, nonatomic) IBOutlet UIWebView *webView;
@end

@implementation ViewController
@synthesize webView;

- (IBAction)BackCB:(id)sender
{
     [self.webView goBack];
}

- (IBAction)GotoCB:(id)sender
{
    [self.webView goForward];
}

- (IBAction)FlashCB:(id)sender
{
    [self.webView reload];
}

- (IBAction)Cancel:(id)sender
{
    if (self.webView.loading) {
        [self.webView stopLoading];
    }
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	[[NSNotificationCenter defaultCenter] addObserver:self
		selector:@selector(ToForeGround:) name:UIApplicationDidBecomeActiveNotification object:nil];
    
	[[NSNotificationCenter defaultCenter] addObserver:self
		selector:@selector(ToBackGround:) name:UIApplicationWillResignActiveNotification object:nil];

    NSString* sVersion = PGIOSHtml5BridgeVersion();
    NSLog(@"pgHtml5Bridge: version: %@", sVersion);
    
    int iReturn = PGIOSHtml5BridgeStart(@"127.0.0.1", 17885, @"");
    if (iReturn) {
        NSLog(@"pgHtml5Bridge: start success!");
    }
    else {
        NSLog(@"pgHtml5Bridge: start failed!");
    }
    
    //[NSURL URLWithString:@"http://cnn.com"]
    //[[NSBundle mainBundle] pathForResource:@"assets" ofType:@"html"]
    NSString *rootPath = [[NSBundle mainBundle] resourcePath];
    NSString *assetsPath = [[NSBundle mainBundle] pathForResource:@"assets" ofType:nil];
    NSLog(@"rootPath = %@ ,assetsPath = %@ ",rootPath,assetsPath);
    
    NSString *filePath = [NSString stringWithFormat:@"%@/index.html",assetsPath];
    NSString *htmlString = [NSString stringWithContentsOfFile:filePath encoding:NSUTF8StringEncoding error:nil];
    NSLog(@"file path = %@ , htmlString = %@ ",filePath,htmlString);
    
    NSURL *url = [[NSURL alloc] initWithString:filePath];
    NSLog(@"url = %@ ",[url absoluteString]);
    
    NSURL *baseUrl = [NSURL URLWithString:filePath];
    NSLog(@"baseUrl = %@ ",[baseUrl absoluteString]);

    NSURLRequest *request = [NSURLRequest requestWithURL:url];
    [self.webView loadRequest:request];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}

- (void)viewDidDisappear:(BOOL)animated
{
	PGIOSHtml5BridgeStop();
    NSLog(@"pgHtml5Bridge: stop");

	[super viewDidDisappear:animated];
}

- (void)ToBackGround:(id)obj
{
    NSLog(@"pgHtml5Bridge: ToBackGround");
}

- (void)ToForeGround:(id)obj
{
    NSLog(@"pgHtml5Bridge: ToForeGround");
}

- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self];
}

@end
