/*************************************************************************
  copyright   : Copyright (C) 2014-2019, Peergine, All rights reserved.
              : www.peergine.com, www.pptun.com
              :
  filename    : pgLibLiveMultiPlayer.js
  discription : 
  modify      : create, chenbichao, 2019/09/19

*************************************************************************/


function pgLibLiveMultiPlayer(oAtx, oUI)
{
	// Check peergine Activex object
	if (!oAtx || typeof(oAtx.Control) == "undefined") {
		alert("pgLibLiveMultiPlayer: oAtx is invalid.");
		return null;
	}

	// Check callback object.
	if (!oUI || typeof(oUI.OnEvent) != "function") {
		alert("pgLibLiveMultiPlayer: oUI is invalid.");
		return null;
	}


	///------------------------------------------------------------------------------
	// API methods.
	
	this.IsInitialized = function() {
		return (this._iInd >= 0);
	}

	this.Initialize = function(sInitParam) {
		if (this._iInd >= 0) {
			this._OutString("pgLibLiveMultiPlayer.Initialize: node has been initialized.");
			return pgErrCode.PG_ERR_BadStatus;
		}

		if (sInitParam == null) {
			this._OutString("pgLibLiveMultiPlayer.Initialize: sInitParam is null");
			return pgErrCode.PG_ERR_BadParam;
		}

		// Find empty live unit. 
		var iLiveInd = -1;
		for (var i = 0; i < _pgLiveMultiPlayCallback.aLiveList.length; i++) {
			if (!_pgLiveMultiPlayCallback.aLiveList[i]) {
				iLiveInd = i;
				break;
			}
		}
		if (iLiveInd < 0) {
			this._OutString("pgLibLiveMultiPlayer.Initialize: No empty live unit.");
			return pgErrCode.PG_ERR_NoSpace;
		}

		// Attach to live list.
		_pgLiveMultiPlayCallback.aLiveList[iLiveInd] = this;
		this._iInd = iLiveInd;

		// Version
		this._LIVE_VER = "3";

		// Init status.
		this._bStarted = false;
		this._sInitParam = sInitParam;

		this._InitPrivate(sInitParam);

		var iErr = this._NodeStart(sInitParam);
		if (iErr > pgErrCode.PG_ERR_Normal) {
			this._OutString("pgLibLiveMultiPlayer.Initialize: Node start failed.");
			if (this._iInd >= 0) {
				_pgLiveMultiPlayCallback.aLiveList[this._iInd] = null;
				this._iInd = -1;
			}
			return iErr;
		}
		
		return pgErrCode.PG_ERR_Normal;
	}

	this.Clean = function() {
		this._NodeStop();

		if (this._iInd >= 0) {
			_pgLiveMultiPlayCallback.aLiveList[this._iInd] = null;
			this._iInd = -1;
		}
	}

	//------------------------------------------------------
	// Start to play media file
	this.Start = function(sFilePath, sViewDiv) {
		if (!this._bStarted) {
			this._OutString("pgLibLiveMultiPlayer.Start: Not initialize");						
			return pgErrCode.PG_ERR_BadStatus;
		}

		var sWndEle = "";
		if (sViewDiv != "") {
			sWndEle = this._oAtx.WndCreate(sViewDiv);
		}
		if (sWndEle == "") {
			return pgErrCode.PG_ERR_BadParam;
		}

		var sParam = "(File){" + this._oAtx.omlEncode(sFilePath) + "}(Wnd){" + sWndEle + "}";
		if (this._oAtx.utilCmd("AviPlay", sParam) != "1") {
			return pgErrCode.PG_ERR_BadParam;
		}
	
		return pgErrCode.PG_ERR_Normal;
	}

	// Stop play media file
	this.Stop = function(sFilePath) {
		if (!this._bStarted) {
			this._OutString("pgLibLiveMultiPlayer.Stop: Not initialize");						
			return;
		}

		if (sFilePath == "") {
			return;
		}

		var sParam = "(File){" + this._oAtx.omlEncode(sFilePath) + "}";
		this._oAtx.utilCmd("AviStop", sParam);
	}

	// Pause play.
	this.Pause = function(sFilePath, bFlag) {
		if (!this._bStarted) {
			this._OutString("pgLibLiveMultiPlayer.Pause: Not initialize");						
			return pgErrCode.PG_ERR_BadStatus;
		}

		if (sFilePath == "") {
			return pgErrCode.PG_ERR_BadParam;
		}

		var iFlag = bFlag ? 1 : 0;
		var sParam = "(File){" + this._oAtx.omlEncode(sFilePath) + "}(Flag){" + iFlag + "}";
		if (this._oAtx.utilCmd("AviPause", sParam) != "1") {
			return pgErrCode.PG_ERR_BadParam;
		}

		return pgErrCode.PG_ERR_Normal;
	}

	// Seek to position.
	this.Seek = function(sFilePath, iPosition) {
		if (!this._bStarted) {
			this._OutString("pgLibLiveMultiPlayer.Seek: Not initialize");						
			return pgErrCode.PG_ERR_BadStatus;
		}

		if (sFilePath == "") {
			return pgErrCode.PG_ERR_BadParam;
		}

		var sParam = "(File){" + this._oAtx.omlEncode(sFilePath) + "}(Position){" + iPosition + "}";
		if (this._oAtx.utilCmd("AviSeek", sParam) != "1") {
			return pgErrCode.PG_ERR_BadParam;
		}

		return pgErrCode.PG_ERR_Normal;
	}


	//------------------------------------------------------
	// Video handle functions.

	this.VideoModeSize = function(iMode, iWidth, iHeight) {
		if (!this._bStarted) {
			this._OutString("pgLibLiveMultiPlayer.VideoModeSize: Not initialize");						
			return pgErrCode.PG_ERR_BadStatus;
		}

		var iErr = pgErrCode.PG_ERR_System;
		if (this._oAtx.ObjectAdd("_vTemp", "PG_CLASS_Video", "", 0x0)) {
			var sValue = "(Mode){" + iMode + "}(Width){" + iWidth + "}(Height){" + iHeight + "}";
			var sData = "(Item){12}(Value){" + this._oAtx.omlEncode(sValue) + "}";
			iErr = this._oAtx.ObjectRequest("_vTemp", 2, sData, "");
			if (iErr > pgErrCode.PG_ERR_Normal) {
				this._OutString("pgLibLiveMultiPlayer.VideoModeSize: iErr=" + iErr);	
			}
			else {
				iErr = pgErrCode.PG_ERR_Normal;
			}
			this._oAtx.ObjectDelete("_vTemp");
		}

		return iErr;
	}

	this.VideoShowMode = function(iMode) {
		if (!this._bStarted) {
			return pgErrCode.PG_ERR_BadStatus;
		}

		if (!this._oAtx.ObjectAdd("_vTemp", "PG_CLASS_Video", "", 0)) {
			this._OutString("pgLibLiveMultiPlayer.VideoShowMode: Add object failed.");						
			return pgErrCode.PG_ERR_System;
		}

		this._oAtx.ObjectRequest("_vTemp", 2, "(Item){10}(Value){" + iMode + "}", "");
		this._oAtx.ObjectDelete("_vTemp");

		return pgErrCode.PG_ERR_Normal;
	}

	this.Version = function() {
		if (!this._bStarted) {
			this._OutString("pgLibLiveMultiRender.Version: Not initialize");						
			return "";
		}

		var sVersion = "";
		var sVerTemp = this._oAtx.omlGetContent(this._oAtx.utilCmd("Version", ""), "Version");
		if (sVerTemp.length > 1) {
			sVersion = sVerTemp.substring(1);
		}

		return (sVersion + "." + this._LIVE_VER);
	}

	///------------------------------------------------------------------------
	// Private member variables.

	// Store ActiveX object and UI callback object.
	this._oAtx = oAtx;
	this._oUI = oUI;
	this._iInd = -1;

	// Store init parameters
	this._sInitParam = "";
	this._bStarted = false;

	///---------------------------------------------------------------------------------
	// Private methods.
	
	//------------------------------------------------------
	// Common functions.

	this._ParseInt = function(sVal, idefVal) {
		try {
			if (sVal != "") {
				return parseInt(sVal);
			}
			return idefVal;
		}
		catch (e) {
			return idefVal;
		}
	}

	this._OutString = function(sStr) {
		if (this._oUI.OnOutString && typeof(this._oUI.OnOutString) == "function") {
			this._oUI.OnOutString(sStr);
		}
	}


	//------------------------------------------------------
	// Callback functions.

	this._OnEvent = function(sAct, sData, sCapID) {
		try {
			if (this._oUI.OnEvent && typeof(this._oUI.OnEvent) == "function") {
				this._oUI.OnEvent(sAct, sData, sCapID);
			}
		}
		catch (ex) {
			this._OutString("pgLibLiveMultiPlayer._OnEvent: ex=" + ex.toString());
		}
	}

	this._OnTimer = function(sExec) {
	}

	this._OnTimeout = function(sExec) {
	}


	//------------------------------------------------------
	// Node handle functions.

	this._NodeStart = function(sInitParam) {

		var iLogLevel0 = this._ParseInt(this._oAtx.omlGetContent(sInitParam, "LogLevel0"), 1);
		var iLogLevel1 = this._ParseInt(this._oAtx.omlGetContent(sInitParam, "LogLevel1"), 1);
		var iLogLevel2 = this._ParseInt(this._oAtx.omlGetContent(sInitParam, "LogLevel2"), 0);
		var iLogLevel3 = this._ParseInt(this._oAtx.omlGetContent(sInitParam, "LogLevel3"), 0);
		var iLogFileSize = this._ParseInt(this._oAtx.omlGetContent(sInitParam, "LogFileSize"), 0);
		var iLogFileNum = this._ParseInt(this._oAtx.omlGetContent(sInitParam, "LogFileNum"), 0);
		var iDebug = this._ParseInt(this._oAtx.omlGetContent(sInitParam, "Debug"), 0);

		var sControlCfg = "Type=1;LogLevel0=" + iLogLevel0 + ";LogLevel1=" + iLogLevel1
			+ ";LogLevel2=" + iLogLevel2 + ";LogLevel3=" + iLogLevel3
			+ ";LogFileSize=" + iLogFileSize + ";LogFileNum=" + iLogFileNum + ";Debug=" + iDebug;
		this._OutString("pgLibLiveMultiPlayer._NodeStart: sControlCfg=" + sControlCfg);

		var sNodeCfg = "Type=0";
		this._OutString("pgLibLiveMultiPlayer._NodeStart: sNodeCfg=" + sNodeCfg);

		// Config atx node.
		this._oAtx.Control = sControlCfg;
		this._oAtx.Node = sNodeCfg;
		this._oAtx.Class = "PG_CLASS_Video:2;PG_CLASS_Audio:2";
		this._oAtx.Local = "Addr=0:0:0:127.0.0.1:0:0";
		this._oAtx.Server = "Name=pgConnectSvr;Addr=127.0.0.1:1234";
		this._oAtx.Relay = "(Relay0){(Type){0}(Load){0}(Addr){127.0.0.1:1234}}";

		// Set node's callback
		this._oAtx.OnExtRequest = eval("_pgLiveMultiPlayCallback.OnExtRequest" + this._iInd);
		this._oAtx.OnReply = eval("_pgLiveMultiPlayCallback.OnReply" + this._iInd);

		// Start atx node.
		if (!this._oAtx.Start(0)) {
			this._OutString("pgLibLiveMultiPlayer._NodeStart: Start node failed.");
			return pgErrCode.PG_ERR_System;
		}

		this._NodeExternal(sInitParam);

		this._bStarted = true;
		return pgErrCode.PG_ERR_Normal;
	}

	this._NodeStop = function() {
		this._bStarted = false;
	}

	this._NodeExternal = function(sInitParam) {
	}

	this._InitPrivate = function(sInitParam) {
	}


	//------------------------------------------------------
	// Timer handles.

	this._TimerStart = function(sParam, iTimeout) {
		try {
			this._OutString("pgLibLiveMultiPlayer._TimerStart: sParam=" + sParam);
			var sJS = "_pgLiveMultiPlayCallback.OnTimeout" + this._iInd + "('" + sParam + "')";
			return window.setTimeout(sJS, (iTimeout * 1000));
		}
		catch (e) {
			return -1;
		}
	}

	this._TimerStop = function(iTimerID) {
		window.clearTimeout(iTimerID);
	}


	///------------------------------------------------------------------------
	// Callback process functions.

	this._OnPlayEvent = function(sData) {
		var sEvent = this._oAtx.omlGetContent(sData, "Event");

		var sFile = this._oAtx.omlGetContent(sData, "File");
		var sFrmCur = this._oAtx.omlGetContent(sData, "FrmCur");
		var sFrmRate = this._oAtx.omlGetContent(sData, "FrmRate");
		var sFrmTotal = this._oAtx.omlGetContent(sData, "FrmTotal");

		var sDataTemp = "file=" + sFile + "&frmcur=" + sFrmCur
			+ "&frmrate=" + sFrmRate + "&frmtotal=" + sFrmTotal;
		
		if (sEvent == "1") {
			this._OnEvent("PlayStart", sDataTemp, "");
		}
		else if (sEvent == "2") {
			this._OnEvent("PlayProgress", sDataTemp, "");
		}
		else if (sEvent == "3") {
			this._OnEvent("PlayStop", sDataTemp, "");
			this.Stop(sFile);
		}
	}

	
	///------------------------------------------------------------------------
	// Node callback functions.

	this._OnExtRequest = function(sObj, uMeth, sData, uHandle, sPeer) {
		this._OutString("pgLibLiveMultiPlayer._OnExtRequest: " + sObj + ", " + uMeth + ", " + sData + ", " + sPeer);

		if (sObj == "") {
			if (uMeth == 33) {
				this._OnPlayEvent(sData);
			}
			return 0;
		}

		return 0;
	}


	//------------------------------------------------------
	// OnReply callback process functions.

	this._OnReply = function(sObj, uErr, sData, sParam) {
		this._OutString("pgLibLiveMultiPlayer._OnReply: " + sObj + ", " + uErr + ", " + sData + ", " + sParam);
		return 1;
	}
}


// Live callback.
var _pgLiveMultiPlayCallback = {

	aLiveList:new Array(null, null, null, null),
	
	OnExtRequest0:function(sObj, uMeth, sData, uHandle, sPeer) {
		if (_pgLiveMultiPlayCallback.aLiveList[0]) {
			return _pgLiveMultiPlayCallback.aLiveList[0]._OnExtRequest(sObj, uMeth, sData, uHandle, sPeer);
		}
		return 0;
	},
	OnReply0:function(sObj, uErr, sData, sParam) {
		if (_pgLiveMultiPlayCallback.aLiveList[0]) {
			return _pgLiveMultiPlayCallback.aLiveList[0]._OnReply(sObj, uErr, sData, sParam);
		}
		return 1;
	},
	OnTimer0:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[0]) {
			return _pgLiveMultiPlayCallback.aLiveList[0]._OnTimer(sExec);
		}
		return 1;
	},
	OnTimeout0:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[0]) {
			return _pgLiveMultiPlayCallback.aLiveList[0]._OnTimeout(sExec);
		}
		return 1;
	},
	
	OnExtRequest1:function(sObj, uMeth, sData, uHandle, sPeer) {
		if (_pgLiveMultiPlayCallback.aLiveList[1]) {
			return _pgLiveMultiPlayCallback.aLiveList[1]._OnExtRequest(sObj, uMeth, sData, uHandle, sPeer);
		}
		return 0;
	},
	OnReply1:function(sObj, uErr, sData, sParam) {
		if (_pgLiveMultiPlayCallback.aLiveList[1]) {
			return _pgLiveMultiPlayCallback.aLiveList[1]._OnReply(sObj, uErr, sData, sParam);
		}
		return 1;
	},
	OnTimer1:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[1]) {
			return _pgLiveMultiPlayCallback.aLiveList[1]._OnTimer(sExec);
		}
		return 1;
	},
	OnTimeout1:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[1]) {
			return _pgLiveMultiPlayCallback.aLiveList[1]._OnTimeout(sExec);
		}
		return 1;
	},

	OnExtRequest2:function(sObj, uMeth, sData, uHandle, sPeer) {
		if (_pgLiveMultiPlayCallback.aLiveList[2]) {
			return _pgLiveMultiPlayCallback.aLiveList[2]._OnExtRequest(sObj, uMeth, sData, uHandle, sPeer);
		}
		return 0;
	},
	OnReply2:function(sObj, uErr, sData, sParam) {
		if (_pgLiveMultiPlayCallback.aLiveList[2]) {
			return _pgLiveMultiPlayCallback.aLiveList[2]._OnReply(sObj, uErr, sData, sParam);
		}
		return 1;
	},
	OnTimer2:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[2]) {
			return _pgLiveMultiPlayCallback.aLiveList[2]._OnTimer(sExec);
		}
		return 1;
	},
	OnTimeout2:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[2]) {
			return _pgLiveMultiPlayCallback.aLiveList[2]._OnTimeout(sExec);
		}
		return 1;
	},

	OnExtRequest3:function(sObj, uMeth, sData, uHandle, sPeer) {
		if (_pgLiveMultiPlayCallback.aLiveList[3]) {
			return _pgLiveMultiPlayCallback.aLiveList[3]._OnExtRequest(sObj, uMeth, sData, uHandle, sPeer);
		}
		return 0;
	},
	OnReply3:function(sObj, uErr, sData, sParam) {
		if (_pgLiveMultiPlayCallback.aLiveList[3]) {
			return _pgLiveMultiPlayCallback.aLiveList[3]._OnReply(sObj, uErr, sData, sParam);
		}
		return 1;
	},
	OnTimer3:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[3]) {
			return _pgLiveMultiPlayCallback.aLiveList[3]._OnTimer(sExec);
		}
		return 1;
	},
	OnTimeout3:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[3]) {
			return _pgLiveMultiPlayCallback.aLiveList[3]._OnTimeout(sExec);
		}
		return 1;
	},

	OnExtRequest4:function(sObj, uMeth, sData, uHandle, sPeer) {
		if (_pgLiveMultiPlayCallback.aLiveList[4]) {
			return _pgLiveMultiPlayCallback.aLiveList[4]._OnExtRequest(sObj, uMeth, sData, uHandle, sPeer);
		}
		return 0;
	},
	OnReply4:function(sObj, uErr, sData, sParam) {
		if (_pgLiveMultiPlayCallback.aLiveList[4]) {
			return _pgLiveMultiPlayCallback.aLiveList[4]._OnReply(sObj, uErr, sData, sParam);
		}
		return 1;
	},
	OnTimer4:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[4]) {
			return _pgLiveMultiPlayCallback.aLiveList[4]._OnTimer(sExec);
		}
		return 1;
	},
	OnTimeout4:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[4]) {
			return _pgLiveMultiPlayCallback.aLiveList[4]._OnTimeout(sExec);
		}
		return 1;
	},

	OnExtRequest5:function(sObj, uMeth, sData, uHandle, sPeer) {
		if (_pgLiveMultiPlayCallback.aLiveList[5]) {
			return _pgLiveMultiPlayCallback.aLiveList[5]._OnExtRequest(sObj, uMeth, sData, uHandle, sPeer);
		}
		return 0;
	},
	OnReply5:function(sObj, uErr, sData, sParam) {
		if (_pgLiveMultiPlayCallback.aLiveList[5]) {
			return _pgLiveMultiPlayCallback.aLiveList[5]._OnReply(sObj, uErr, sData, sParam);
		}
		return 1;
	},
	OnTimer5:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[5]) {
			return _pgLiveMultiPlayCallback.aLiveList[5]._OnTimer(sExec);
		}
		return 1;
	},
	OnTimeout5:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[5]) {
			return _pgLiveMultiPlayCallback.aLiveList[5]._OnTimeout(sExec);
		}
		return 1;
	},

	OnExtRequest6:function(sObj, uMeth, sData, uHandle, sPeer) {
		if (_pgLiveMultiPlayCallback.aLiveList[6]) {
			return _pgLiveMultiPlayCallback.aLiveList[6]._OnExtRequest(sObj, uMeth, sData, uHandle, sPeer);
		}
		return 0;
	},
	OnReply6:function(sObj, uErr, sData, sParam) {
		if (_pgLiveMultiPlayCallback.aLiveList[6]) {
			return _pgLiveMultiPlayCallback.aLiveList[6]._OnReply(sObj, uErr, sData, sParam);
		}
		return 1;
	},
	OnTimer6:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[6]) {
			return _pgLiveMultiPlayCallback.aLiveList[6]._OnTimer(sExec);
		}
		return 1;
	},
	OnTimeout6:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[6]) {
			return _pgLiveMultiPlayCallback.aLiveList[6]._OnTimeout(sExec);
		}
		return 1;
	},

	OnExtRequest7:function(sObj, uMeth, sData, uHandle, sPeer) {
		if (_pgLiveMultiPlayCallback.aLiveList[7]) {
			return _pgLiveMultiPlayCallback.aLiveList[7]._OnExtRequest(sObj, uMeth, sData, uHandle, sPeer);
		}
		return 0;
	},
	OnReply7:function(sObj, uErr, sData, sParam) {
		if (_pgLiveMultiPlayCallback.aLiveList[7]) {
			return _pgLiveMultiPlayCallback.aLiveList[7]._OnReply(sObj, uErr, sData, sParam);
		}
		return 1;
	},
	OnTimer7:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[7]) {
			return _pgLiveMultiPlayCallback.aLiveList[7]._OnTimer(sExec);
		}
		return 1;
	},
	OnTimeout7:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[7]) {
			return _pgLiveMultiPlayCallback.aLiveList[7]._OnTimeout(sExec);
		}
		return 1;
	},

	OnExtRequest8:function(sObj, uMeth, sData, uHandle, sPeer) {
		if (_pgLiveMultiPlayCallback.aLiveList[8]) {
			return _pgLiveMultiPlayCallback.aLiveList[8]._OnExtRequest(sObj, uMeth, sData, uHandle, sPeer);
		}
		return 0;
	},
	OnReply8:function(sObj, uErr, sData, sParam) {
		if (_pgLiveMultiPlayCallback.aLiveList[8]) {
			return _pgLiveMultiPlayCallback.aLiveList[8]._OnReply(sObj, uErr, sData, sParam);
		}
		return 1;
	},
	OnTimer8:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[8]) {
			return _pgLiveMultiPlayCallback.aLiveList[8]._OnTimer(sExec);
		}
		return 1;
	},
	OnTimeout8:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[8]) {
			return _pgLiveMultiPlayCallback.aLiveList[8]._OnTimeout(sExec);
		}
		return 1;
	},

	OnExtRequest9:function(sObj, uMeth, sData, uHandle, sPeer) {
		if (_pgLiveMultiPlayCallback.aLiveList[9]) {
			return _pgLiveMultiPlayCallback.aLiveList[9]._OnExtRequest(sObj, uMeth, sData, uHandle, sPeer);
		}
		return 0;
	},
	OnReply9:function(sObj, uErr, sData, sParam) {
		if (_pgLiveMultiPlayCallback.aLiveList[9]) {
			return _pgLiveMultiPlayCallback.aLiveList[9]._OnReply(sObj, uErr, sData, sParam);
		}
		return 1;
	},
	OnTimer9:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[9]) {
			return _pgLiveMultiPlayCallback.aLiveList[9]._OnTimer(sExec);
		}
		return 1;
	},
	OnTimeout9:function(sExec) {
		if (_pgLiveMultiPlayCallback.aLiveList[9]) {
			return _pgLiveMultiPlayCallback.aLiveList[9]._OnTimeout(sExec);
		}
		return 1;
	}
};
