/*
 * Decompiled with CFR 0.152.
 */
package com.peergine.plugin.android;

import android.media.AudioRecord;
import android.os.Process;
import android.util.Log;
import com.peergine.plugin.android.pgSysJNI;
import java.util.concurrent.atomic.AtomicInteger;

public class pgSysAudioIn {
    private int m_iID = 0;
    private AudioRecord m_Recorder = null;
    private byte[] m_byteData = null;
    private Thread m_threadPoll = null;
    private boolean m_bThreadPollRun = false;
    private static boolean m_bInputOpened = false;
    private static OutCallback m_outCallback = null;
    private static AtomicInteger m_atomicOutCallback = new AtomicInteger();

    public pgSysAudioIn(int iID) {
        this.m_iID = iID;
    }

    public int Open(int uSampleBits, int uSampleRate, int uChannels, int uPackBytes, int iMicNo) {
        block11: {
            int iMinBufSize;
            int iSampleFmt;
            block10: {
                Log.d((String)"pgnpp", (String)("pgSysAudioIn.Open, uSampleBits=" + uSampleBits + ", uSampleRate=" + uSampleRate + ", uPackBytes=" + uPackBytes));
                this.m_byteData = new byte[uPackBytes];
                iSampleFmt = uSampleBits == 16 ? 2 : 3;
                iMinBufSize = AudioRecord.getMinBufferSize((int)uSampleRate, (int)16, (int)iSampleFmt);
                if (iMinBufSize > 0) break block10;
                Log.d((String)"pgnpp", (String)"pgSysAudioIn.Open, failed, get min buffer sise");
                return 0;
            }
            Log.d((String)"pgnpp", (String)("pgSysAudioIn.Open, iMinBufSize=" + iMinBufSize));
            int iBufSize = uPackBytes * 6;
            if (iBufSize < iMinBufSize) {
                iBufSize = iMinBufSize / uPackBytes * uPackBytes + uPackBytes;
            }
            int iMicNoTemp = 1;
            if (iMicNo != 0) {
                iMicNoTemp = iMicNo;
            }
            this.m_Recorder = new AudioRecord(iMicNoTemp, uSampleRate, 16, iSampleFmt, iBufSize);
            if (this.m_Recorder.getState() == 1) break block11;
            Log.d((String)"pgnpp", (String)"pgSysAudioIn.Open, failed, not inited");
            return 0;
        }
        try {
            this.m_Recorder.startRecording();
            int iPollSize = 0;
            boolean bReadFirstResult = false;
            int i = 0;
            while (i < 5) {
                int iRead = this.m_Recorder.read(this.m_byteData, iPollSize, this.m_byteData.length - iPollSize);
                if (iRead > 0 && (iPollSize += iRead) >= uPackBytes) {
                    bReadFirstResult = true;
                    break;
                }
                Log.d((String)"pgnpp", (String)("pgSysAudioIn.Open: Read=" + iRead));
                ++i;
            }
            if (bReadFirstResult) {
                this.m_bThreadPollRun = true;
                this.m_threadPoll = new PollThread();
                this.m_threadPoll.start();
                pgSysAudioIn.SetInputOpened(true);
                Log.d((String)"pgnpp", (String)"pgSysAudioIn Open: success");
            } else {
                Log.d((String)"pgnpp", (String)"pgSysAudioIn.Open: read first packet failed");
            }
            pgSysJNI.AudioInOnOpen(this.m_iID);
            return 1;
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysAudioIn.Open: ex=" + ex.toString()));
            return 0;
        }
    }

    public void Close() {
        try {
            Log.d((String)"pgnpp", (String)"pgSysAudioIn.Close");
            pgSysAudioIn.SetInputOpened(false);
            this.m_bThreadPollRun = false;
            if (this.m_Recorder != null) {
                this.m_Recorder.stop();
                this.m_Recorder.release();
                this.m_Recorder = null;
            }
            pgSysJNI.AudioInOnClose(this.m_iID);
            Log.d((String)"pgnpp", (String)"pgSysAudioIn.Close: finish");
        }
        catch (Exception ex) {
            pgSysJNI.AudioInOnClose(this.m_iID);
            Log.d((String)"pgnpp", (String)("pgSysAudioIn.Close: ex=" + ex.toString()));
        }
    }

    public int Poll() {
        Log.d((String)"pgnpp", (String)"pgSysAudioIn.Poll: No immplement");
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean IsInputOpened() {
        try {
            boolean bIsOpened = false;
            AtomicInteger atomicInteger = m_atomicOutCallback;
            synchronized (atomicInteger) {
                bIsOpened = m_bInputOpened;
            }
            return bIsOpened;
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysAudioIn.IsInputOpened: ex=" + ex.toString()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SetOutCallback(OutCallback outCallback) {
        try {
            AtomicInteger atomicInteger = m_atomicOutCallback;
            synchronized (atomicInteger) {
                m_outCallback = outCallback;
            }
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysAudioIn.SetOutCallback: ex=" + ex.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void SetInputOpened(boolean bOpened) {
        try {
            AtomicInteger atomicInteger = m_atomicOutCallback;
            synchronized (atomicInteger) {
                m_bInputOpened = bOpened;
            }
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysAudioIn.SetInputOpened: ex=" + ex.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean PollOutCallback() {
        try {
            OutCallback outCallback = null;
            AtomicInteger atomicInteger = m_atomicOutCallback;
            synchronized (atomicInteger) {
                if (m_outCallback != null) {
                    outCallback = m_outCallback;
                }
            }
            if (outCallback != null) {
                return outCallback.OnPoll();
            }
            return true;
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysAudioIn.PollOutCallback: ex=" + ex.toString()));
            return true;
        }
    }

    public static interface OutCallback {
        public boolean OnPoll();
    }

    class PollThread
    extends Thread {
        PollThread() {
        }

        @Override
        public void run() {
            try {
                Process.setThreadPriority((int)-19);
                Log.d((String)"pgnpp", (String)"pgSysAudioIn.PollThread.run: start");
                boolean bOutCallbackSync = true;
                while (pgSysAudioIn.this.m_bThreadPollRun) {
                    int iRead = pgSysAudioIn.this.m_Recorder.read(pgSysAudioIn.this.m_byteData, 0, pgSysAudioIn.this.m_byteData.length);
                    if (iRead <= 0) {
                        Thread.sleep(10L);
                        continue;
                    }
                    if (bOutCallbackSync) {
                        pgSysJNI.AudioInOnRecord(pgSysAudioIn.this.m_iID, pgSysAudioIn.this.m_byteData, iRead);
                    }
                    bOutCallbackSync = pgSysAudioIn.PollOutCallback();
                }
                Log.d((String)"pgnpp", (String)"pgSysAudioIn.PollThread.run: exit");
            }
            catch (Exception ex) {
                Log.d((String)"pgnpp", (String)("pgSysAudioIn.PollThread Exception, ex=" + ex.toString()));
            }
        }
    }
}

