/*
 * Decompiled with CFR 0.152.
 */
package com.peergine.plugin.android;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Log;
import java.nio.ByteBuffer;

public class pgSysVideoCodec {
    public static final int COLOR_FORMAT_Null = 0;
    public static final int COLOR_FORMAT_YUV420P = 1;
    public static final int COLOR_FORMAT_YUV420SP = 2;
    public static final int CODEC_VIDEO_RGB = 0;
    public static final int CODEC_VIDEO_H264 = 4;
    public static final int CODEC_VIDEO_H265 = 8;
    public byte[] byInData = null;
    private static final int H264NAL_TYPE_NAL = 0;
    private static final int H264NAL_TYPE_SLICE = 1;
    private static final int H264NAL_TYPE_SLICE_DPA = 2;
    private static final int H264NAL_TYPE_SLICE_DPB = 3;
    private static final int H264NAL_TYPE_SLICE_DPC = 4;
    private static final int H264NAL_TYPE_SLICE_IDR = 5;
    private static final int H264NAL_TYPE_SEI = 6;
    private static final int H264NAL_TYPE_SPS = 7;
    private static final int H264NAL_TYPE_PPS = 8;
    private static final int H265NAL_UNIT_CODED_SLICE_TRAIL_N = 0;
    private static final int H265NAL_UNIT_CODED_SLICE_TRAIL_R = 1;
    private static final int H265NAL_UNIT_CODED_SLICE_TSA_N = 2;
    private static final int H265NAL_UNIT_CODED_SLICE_TLA_R = 3;
    private static final int H265NAL_UNIT_CODED_SLICE_STSA_N = 4;
    private static final int H265NAL_UNIT_CODED_SLICE_STSA_R = 5;
    private static final int H265NAL_UNIT_CODED_SLICE_RADL_N = 6;
    private static final int H265NAL_UNIT_CODED_SLICE_RADL_R = 7;
    private static final int H265NAL_UNIT_CODED_SLICE_RASL_N = 8;
    private static final int H265NAL_UNIT_CODED_SLICE_RASL_R = 9;
    private static final int H265NAL_UNIT_CODED_SLICE_BLA_W_LP = 16;
    private static final int H265NAL_UNIT_CODED_SLICE_BLA_W_RADL = 17;
    private static final int H265NAL_UNIT_CODED_SLICE_BLA_N_LP = 18;
    private static final int H265NAL_UNIT_CODED_SLICE_IDR_W_RADL = 19;
    private static final int H265NAL_UNIT_CODED_SLICE_IDR_N_LP = 20;
    private static final int H265NAL_UNIT_CODED_SLICE_CRA = 21;
    private static final int H265NAL_UNIT_VPS = 32;
    private static final int H265NAL_UNIT_SPS = 33;
    private static final int H265NAL_UNIT_PPS = 34;
    private static final int H265NAL_UNIT_ACCESS_UNIT_DELIMITER = 35;
    private static final int H265NAL_UNIT_EOS = 36;
    private static final int H265NAL_UNIT_EOB = 37;
    private static final int H265NAL_UNIT_FILLER_DATA = 38;
    private static final int H265NAL_UNIT_PREFIX_SEI = 39;
    private static final int H265NAL_UNIT_SUFFIX_SEI = 40;
    private static final int H265NAL_UNIT_INVALID = 64;
    private MediaCodec m_MediaCodec = null;
    private MediaCodec.BufferInfo m_BufferInfo = null;
    private CodecInfo m_CodecInfo = null;
    private byte[] m_byBufCache = null;
    private int m_iColorFormat = -1;
    private int m_iFrameInterval = -1;
    private int m_iFrameCount = 0;
    private OutData m_OutData = null;
    private int m_iEncode = 0;
    private int m_iCodecID = 0;
    private int m_iWidth = 0;
    private int m_iHeight = 0;
    private int m_iAlignWidth = 0;
    private int m_iAlignHeight = 0;
    private int m_iSizeXY = 0;
    private int m_iSizeUV = 0;

    public int Init(int iCodecID, int iEnc, int iW, int iH, int iFrameRate, int iKeyFrmRate, int iBitRate) {
        String sCodecType;
        block10: {
            block9: {
                try {
                    sCodecType = "";
                    if (iCodecID == 4) {
                        sCodecType = "video/avc";
                        break block9;
                    }
                    if (iCodecID == 8) {
                        sCodecType = "video/hevc";
                        break block9;
                    }
                    return 0;
                }
                catch (Exception ex) {
                    Log.d((String)"pgnpp", (String)("pgSysVideoCodec.Init: ex=" + ex.toString()));
                    return 0;
                }
            }
            if (this.CheckCodec(sCodecType, iEnc != 0)) break block10;
            return 0;
        }
        int iBufSize = iW * iH * 3;
        this.byInData = new byte[iBufSize];
        this.m_OutData = new OutData(iBufSize);
        this.m_iAlignWidth = 0;
        this.m_iAlignHeight = 0;
        if (iEnc != 0) {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)sCodecType, (int)iW, (int)iH);
            mediaFormat.setInteger("bitrate", iBitRate);
            mediaFormat.setInteger("frame-rate", iFrameRate);
            mediaFormat.setInteger("color-format", this.m_iColorFormat);
            mediaFormat.setInteger("i-frame-interval", iKeyFrmRate / iFrameRate);
            this.m_MediaCodec = MediaCodec.createEncoderByType((String)sCodecType);
            this.m_MediaCodec.configure(mediaFormat, null, null, 1);
            this.m_MediaCodec.start();
        } else {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)sCodecType, (int)iW, (int)iH);
            mediaFormat.setInteger("color-format", this.m_iColorFormat);
            this.m_MediaCodec = MediaCodec.createDecoderByType((String)sCodecType);
            this.m_MediaCodec.configure(mediaFormat, null, null, 0);
            MediaFormat fmtOut = this.m_MediaCodec.getOutputFormat();
            if (fmtOut != null) {
                this.GetAlignSize(fmtOut);
            }
            this.m_MediaCodec.start();
        }
        this.m_BufferInfo = new MediaCodec.BufferInfo();
        this.m_iFrameInterval = iFrameRate != 0 ? 1000 / iFrameRate * 1000 : 0;
        this.m_iFrameCount = 0;
        this.m_iEncode = iEnc;
        this.m_iCodecID = iCodecID;
        this.m_iWidth = iW;
        this.m_iHeight = iH;
        this.m_iSizeXY = this.m_iWidth * this.m_iHeight;
        this.m_iSizeUV = this.m_iSizeXY / 2;
        Log.d((String)"pgnpp", (String)("pgSysVideoCodec.Init: '" + sCodecType + "' success."));
        return 1;
    }

    public int Encode(int iSizeBmp, int iKeyFrame) {
        block16: {
            block15: {
                if (this.m_iEncode != 0) break block15;
                return 0;
            }
            if (this.byInData != null) break block16;
            return 0;
        }
        try {
            ByteBuffer[] inputBuffers = this.m_MediaCodec.getInputBuffers();
            ByteBuffer[] outputBuffers = this.m_MediaCodec.getOutputBuffers();
            int inpuIndex = this.m_MediaCodec.dequeueInputBuffer(-1L);
            if (inpuIndex >= 0) {
                inputBuffers[inpuIndex].clear();
                inputBuffers[inpuIndex].put(this.byInData, 0, iSizeBmp);
                int iQueFlag = 0;
                if (iKeyFrame != 0) {
                    iQueFlag |= 1;
                    Log.d((String)"pgnpp", (String)"pgSysVideoCodec.Encode: force key frame");
                }
                this.m_MediaCodec.queueInputBuffer(inpuIndex, 0, iSizeBmp, this.GetFrameTime(), iQueFlag);
            }
            int iRet = 0;
            int outputIndex = this.m_MediaCodec.dequeueOutputBuffer(this.m_BufferInfo, 20000L);
            while (outputIndex >= 0) {
                this.m_OutData.iDataSize = 0;
                this.m_OutData.iKeyFrame = 0;
                int iOutDataSize = this.m_BufferInfo.size;
                if (this.m_byBufCache != null) {
                    if (this.FrameIsIDR(outputBuffers[outputIndex].get(4))) {
                        System.arraycopy(this.m_byBufCache, 0, this.m_OutData.byData, 0, this.m_byBufCache.length);
                        outputBuffers[outputIndex].get(this.m_OutData.byData, this.m_byBufCache.length, iOutDataSize);
                        this.m_OutData.iDataSize = this.m_byBufCache.length + iOutDataSize;
                        this.m_OutData.iKeyFrame = 1;
                    } else {
                        outputBuffers[outputIndex].get(this.m_OutData.byData, 0, iOutDataSize);
                        this.m_OutData.iDataSize = iOutDataSize;
                    }
                    iRet = 1;
                } else if (this.FrameIsSPS(outputBuffers[outputIndex].get(4)) && outputBuffers[outputIndex].get(0) == 0 && outputBuffers[outputIndex].get(1) == 0 && outputBuffers[outputIndex].get(2) == 0 && outputBuffers[outputIndex].get(3) == 1) {
                    this.m_byBufCache = new byte[iOutDataSize];
                    outputBuffers[outputIndex].get(this.m_byBufCache, 0, iOutDataSize);
                    Log.d((String)"pgnpp", (String)"pgSysVideoCodec.Encode: Backup SPS head.");
                } else {
                    String sHeadData = "";
                    int iInd = 0;
                    while (iInd < 5) {
                        sHeadData = String.valueOf(sHeadData) + String.format("%02X ", outputBuffers[outputIndex].get(iInd));
                        ++iInd;
                    }
                    Log.d((String)"pgnpp", (String)("pgSysVideoCodec.Encode: There is no SPS head. Data: " + sHeadData));
                }
                this.m_MediaCodec.releaseOutputBuffer(outputIndex, false);
                if (iRet != 0) break;
                outputIndex = this.m_MediaCodec.dequeueOutputBuffer(this.m_BufferInfo, 0L);
            }
            if (iRet == 0) {
                Log.d((String)"pgnpp", (String)("pgSysVideoCodec.Encode: Not output frame. iSizeBmp=" + iSizeBmp + ", iKeyFrame=" + iKeyFrame));
            }
            return iRet;
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysVideoCodec.Encode: ex=" + ex.toString()));
            return 0;
        }
    }

    public int Decode(int iSizeCmp, int iKeyFrame) {
        block21: {
            block20: {
                if (this.m_iEncode == 0) break block20;
                return 0;
            }
            if (this.byInData != null) break block21;
            return 0;
        }
        try {
            MediaFormat fmtOut;
            ByteBuffer[] inputBuffers = this.m_MediaCodec.getInputBuffers();
            ByteBuffer[] outputBuffers = this.m_MediaCodec.getOutputBuffers();
            int inputIndex = this.m_MediaCodec.dequeueInputBuffer(-1L);
            if (inputIndex >= 0) {
                inputBuffers[inputIndex].clear();
                inputBuffers[inputIndex].put(this.byInData, 0, iSizeCmp);
                this.m_MediaCodec.queueInputBuffer(inputIndex, 0, iSizeCmp, 0L, 0);
            }
            int iRet = 0;
            int outputIndex = this.m_MediaCodec.dequeueOutputBuffer(this.m_BufferInfo, 20000L);
            while (outputIndex >= 0) {
                int iOutDataSize = this.m_BufferInfo.size;
                int iAlignWidth = this.m_iAlignWidth;
                int iAlignHeight = this.m_iAlignHeight;
                if (this.m_iSizeXY < iOutDataSize && iAlignHeight == 0) {
                    boolean bNotFound;
                    block22: {
                        bNotFound = true;
                        if (iAlignWidth == 0) {
                            int w = 16;
                            while (w <= 128) {
                                int h = 16;
                                while (h <= w) {
                                    iAlignWidth = ((this.m_iWidth - 1) / w + 1) * w;
                                    iAlignHeight = ((this.m_iHeight - 1) / h + 1) * h;
                                    int size = iAlignWidth * iAlignHeight * 3 / 2;
                                    if (size == iOutDataSize) {
                                        bNotFound = false;
                                        break block22;
                                    }
                                    h <<= 1;
                                }
                                w <<= 1;
                            }
                        } else {
                            int h = 16;
                            while (h <= 128) {
                                iAlignHeight = ((this.m_iHeight - 1) / h + 1) * h;
                                int size = iAlignWidth * iAlignHeight * 3 / 2;
                                if (size == iOutDataSize) {
                                    bNotFound = false;
                                    break;
                                }
                                h <<= 1;
                            }
                        }
                    }
                    if (bNotFound) {
                        iAlignWidth = this.m_iWidth;
                        iAlignHeight = this.m_iHeight;
                    }
                }
                if (iAlignWidth > this.m_iWidth || iAlignHeight > this.m_iHeight) {
                    if (this.m_byBufCache == null) {
                        this.m_byBufCache = new byte[this.m_iSizeXY * 2];
                    }
                    outputBuffers[outputIndex].get(this.m_byBufCache, 0, iOutDataSize);
                    int iAlignSizeXY = iAlignWidth * iAlignHeight;
                    System.arraycopy(this.m_byBufCache, 0, this.m_OutData.byData, 0, this.m_iSizeXY);
                    System.arraycopy(this.m_byBufCache, iAlignSizeXY, this.m_OutData.byData, this.m_iSizeXY, this.m_iSizeUV);
                    this.m_OutData.iDataSize = this.m_iSizeXY + this.m_iSizeUV;
                } else {
                    outputBuffers[outputIndex].get(this.m_OutData.byData, 0, iOutDataSize);
                    this.m_OutData.iDataSize = iOutDataSize;
                }
                iRet = 1;
                this.m_MediaCodec.releaseOutputBuffer(outputIndex, false);
                if (iRet != 0) break;
                outputIndex = this.m_MediaCodec.dequeueOutputBuffer(this.m_BufferInfo, 0L);
            }
            if (outputIndex < 0 && outputIndex == -2 && (fmtOut = this.m_MediaCodec.getOutputFormat()) != null) {
                this.GetAlignSize(fmtOut);
            }
            if (iRet == 0) {
                Log.d((String)"pgnpp", (String)("pgSysVideoCodec.Decode: Not output frame. iSizeCmp=" + iSizeCmp + ", iKeyFrame=" + iKeyFrame + ", iErr=" + outputIndex));
            }
            return iRet;
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysVideoCodec.Decode: ex=" + ex.toString()));
            return 0;
        }
    }

    public void Clean() {
        try {
            if (this.m_MediaCodec != null) {
                this.m_MediaCodec.stop();
                this.m_MediaCodec.release();
                this.m_MediaCodec = null;
                this.m_byBufCache = null;
                this.m_OutData = null;
                this.byInData = null;
            }
            this.m_BufferInfo = null;
            this.m_iColorFormat = -1;
            this.m_iFrameInterval = -1;
            this.m_iFrameCount = 0;
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysVideoCodec.Clean: ex=" + ex.toString()));
        }
    }

    public CodecInfo GetCodecInfo() {
        return this.m_CodecInfo;
    }

    public OutData GetData() {
        return this.m_OutData;
    }

    private boolean CheckCodec(String sType, boolean bIsEncode) {
        int iFormat;
        block14: {
            MediaCodecInfo codecInfo;
            block13: {
                codecInfo = null;
                int iCodecs = MediaCodecList.getCodecCount();
                int i = 0;
                while (i < iCodecs) {
                    MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
                    if (info.isEncoder() == bIsEncode) {
                        String[] sTypes = info.getSupportedTypes();
                        int j = 0;
                        while (j < sTypes.length) {
                            if (sTypes[j].equals(sType)) {
                                codecInfo = info;
                                break;
                            }
                            ++j;
                        }
                        if (codecInfo != null) break;
                    }
                    ++i;
                }
                if (codecInfo != null) break block13;
                Log.d((String)"pgnpp", (String)("pgSysVideoCodec.CheckCodec, Not support '" + sType + "' codec!"));
                return false;
            }
            try {
                iFormat = -1;
                MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType(sType);
                int i = 0;
                while (i < capabilities.colorFormats.length) {
                    Log.d((String)"pgnpp", (String)("pgSysVideoCodec.CheckCodec, support color format=" + capabilities.colorFormats[i]));
                    if (capabilities.colorFormats[i] == 21 || capabilities.colorFormats[i] == 19) {
                        iFormat = capabilities.colorFormats[i];
                        break;
                    }
                    ++i;
                }
                if (iFormat == 21 || iFormat == 19) break block14;
                Log.d((String)"pgnpp", (String)"pgSysVideoCodec.CheckCodec, Not support 'YUV420SP' or 'YUV420P' color format!");
                return false;
            }
            catch (Exception ex) {
                Log.d((String)"pgnpp", (String)("pgSysVideoCodec.CheckCodec, ex=" + ex.toString()));
                return false;
            }
        }
        this.m_iColorFormat = iFormat;
        this.m_CodecInfo = new CodecInfo();
        if (iFormat == 21) {
            this.m_CodecInfo.iColorFormat = 2;
        } else if (iFormat == 19) {
            this.m_CodecInfo.iColorFormat = 1;
        }
        return true;
    }

    private long GetFrameTime() {
        long lTime = 128 + this.m_iFrameCount * this.m_iFrameInterval;
        ++this.m_iFrameCount;
        return lTime;
    }

    private boolean FrameIsSPS(int iData) {
        if (this.m_iCodecID == 4) {
            return (iData & 0x1F) == 7;
        }
        if (this.m_iCodecID == 8) {
            int iTemp = (iData & 0x7E) >> 1;
            switch (iTemp) {
                case 32: 
                case 33: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean FrameIsIDR(int iData) {
        if (this.m_iCodecID == 4) {
            return (iData & 0x1F) == 5;
        }
        if (this.m_iCodecID == 8) {
            int iTemp = (iData & 0x7E) >> 1;
            switch (iTemp) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void GetAlignSize(MediaFormat fmt) {
        int iKeyStride = fmt.getInteger("stride");
        this.m_iAlignWidth = iKeyStride > 0 ? iKeyStride : 0;
        int iKeyStrideHeight = fmt.getInteger("slice-height");
        this.m_iAlignHeight = iKeyStrideHeight > 0 ? iKeyStrideHeight : 0;
    }

    public static class CodecInfo {
        public int iColorFormat = 0;
    }

    public static class OutData {
        public byte[] byData = null;
        public int iDataSize = 0;
        public int iKeyFrame = 0;

        public OutData(int iBufSize) {
            this.byData = new byte[iBufSize];
        }
    }
}

