/*
 * Decompiled with CFR 0.152.
 */
package com.peergine.plugin.android;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.peergine.plugin.android.pgSysJNI;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;

public class pgSysWnd
extends SurfaceView
implements SurfaceHolder.Callback,
Camera.PreviewCallback {
    private static final int TYPE_Null = 0;
    private static final int TYPE_Camera = 1;
    private static final int TYPE_Video = 2;
    private static final int TYPE_Board = 3;
    private static final int VIDEO_BITMAP_DstInSrc = 0;
    private static final int VIDEO_BITMAP_SrcInDst = 1;
    private static final int VIDEO_BITMAP_SrcFitDst = 2;
    private static final int VIDEO_MODE_Unknown = 0;
    private static final int VIDEO_MODE_OpenGL = 1;
    private static final int VIDEO_MODE_GUI = 2;
    private int m_iType = 0;
    private int m_iWndID = 0;
    private int m_iExtID = 0;
    private int m_iProc = 0;
    private Handler m_Handler = null;
    private int m_iCameraPixBytes = 0;
    private int m_iCameraWidth = 0;
    private int m_iCameraHeight = 0;
    private int m_iCameraFrmRate = 0;
    private int m_iCameraRotate = 0;
    private int m_iCameraNo = 0;
    private int m_iCameraFacing = -1;
    private Camera m_Camera = null;
    private int m_iCameraFormat = -1;
    private int m_iCameraStaOpen = 0;
    private int m_iCameraStaClose = 0;
    private int m_iWidth = 0;
    private int m_iHeight = 0;
    private int m_iWndWidth = 0;
    private int m_iWndHeight = 0;
    private float m_fScaleX = 1.0f;
    private float m_fScaleY = 1.0f;
    private Bitmap m_Bmp = null;
    private PorterDuffXfermode m_ModeXOR = null;
    private PorterDuffXfermode m_ModeSRC = null;
    private Bitmap m_BmpVideo = null;
    private Paint m_PaintVideo = null;
    private Rect m_RectVideo = null;
    private int m_iVideoFillMode = 0;
    private int m_iVideoFillCount = 0;
    private int m_iVideoWidth = 0;
    private int m_iVideoHeight = 0;
    private int m_iVideoMode = 0;
    private int m_iVideoHasSurface = 0;
    public int[] m_iVideoImgBuffer = null;
    public int m_iVideoImgSize = 0;
    private int m_iLclShape = 0;
    private int m_iLclColor = 0;
    private int m_iLclWidth = 0;
    private int m_iLclType = 0;
    private int m_iRmtShape = 0;
    private int m_iRmtColor = 0;
    private int m_iRmtWidth = 0;
    private int m_iRmtType = 0;
    private int m_iPosDownX = 0;
    private int m_iPosDownY = 0;
    private int m_iPosPrevX = 0;
    private int m_iPosPrevY = 0;
    private int m_iPosLastX = 0;
    private int m_iPosLastY = 0;
    private int m_iPosTempX = 0;
    private int m_iPosTempY = 0;
    private int[] m_iPntInput = new int[128];
    private int m_iPntInd = 0;
    private int m_iMouseStatus = 0;
    private int m_iMouseTrack = 0;

    public pgSysWnd(Context ctx) {
        super(ctx);
        try {
            this.m_Handler = new Handler(){

                public void handleMessage(Message msg) {
                    try {
                        pgSysJNI.WndEventProc(pgSysWnd.this.m_iWndID, msg.what, msg.arg1, msg.arg2);
                    }
                    catch (Exception ex) {
                        Log.d((String)"pgnpp", (String)"handleMessage Exception");
                    }
                }
            };
            this.m_ModeXOR = new PorterDuffXfermode(PorterDuff.Mode.XOR);
            this.m_ModeSRC = new PorterDuffXfermode(PorterDuff.Mode.SRC);
            SurfaceHolder holder = this.getHolder();
            holder.setType(3);
            holder.addCallback((SurfaceHolder.Callback)this);
            this.setFocusable(true);
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysWnd: ex=" + ex.toString()));
        }
    }

    public void SetParam(int iWndID, int iWidth, int iHeight) {
        String strTemp = String.format("SetParam, iWndID=%d, iWidth=%d, iHeight=%d", iWndID, iWidth, iHeight);
        Log.d((String)"pgnpp", (String)strTemp);
        this.m_iWndID = iWndID;
        this.m_iWidth = iWidth;
        this.m_iHeight = iHeight;
    }

    public void SetSize(int iWidth, int iHeight) {
        this.m_iWidth = iWidth;
        this.m_iHeight = iHeight;
    }

    public int GetSize() {
        return this.m_iWidth << 16 & 0xFFFF0000 | this.m_iHeight & 0xFFFF;
    }

    public boolean PostRunnable(Runnable r, int iDelay) {
        block5: {
            block4: {
                try {
                    if (iDelay <= 0) break block4;
                    if (this.m_Handler.postDelayed(r, (long)iDelay)) {
                        return true;
                    }
                    break block5;
                }
                catch (Exception ex) {
                    Log.d((String)"pgnpp", (String)"PostRunnable Exception");
                    return false;
                }
            }
            if (!this.m_Handler.post(r)) break block5;
            return true;
        }
        return false;
    }

    public void PostClean() {
        this.PostRunnable(new Runnable(){

            @Override
            public void run() {
                SurfaceHolder holder;
                Canvas canvas;
                if (pgSysWnd.this.m_Bmp != null) {
                    pgSysWnd.this.m_Bmp = null;
                }
                if (pgSysWnd.this.m_iType != 1 && (canvas = (holder = pgSysWnd.this.getHolder()).lockCanvas()) != null) {
                    pgSysWnd.this.onDrawProc(canvas);
                    holder.unlockCanvasAndPost(canvas);
                }
            }
        }, 0);
    }

    public void PostDraw() {
        this.PostRunnable(new Runnable(){

            @Override
            public void run() {
                SurfaceHolder holder;
                Canvas canvas;
                if (pgSysWnd.this.m_iType != 1 && (canvas = (holder = pgSysWnd.this.getHolder()).lockCanvas()) != null) {
                    pgSysWnd.this.onDrawProc(canvas);
                    holder.unlockCanvasAndPost(canvas);
                }
            }
        }, 0);
    }

    public int EventPost(int iEvent, int iParam0, int iParam1) {
        try {
            Message msg = Message.obtain((Handler)this.m_Handler, (int)iEvent, (int)iParam0, (int)iParam1, (Object)((Object)this));
            if (this.m_Handler.sendMessage(msg)) {
                return 1;
            }
            return 0;
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)"EventPost Exception");
            return 0;
        }
    }

    public void EventProc(int iEvent, int iParam0, int iParam1) {
        if (this.m_iProc == 0 || this.m_iType != 3) {
            return;
        }
        if (!this.InitBitmap()) {
            return;
        }
        Paint paint0 = this.NewPaint(this.m_iLclColor, this.m_iLclWidth, this.m_iLclType);
        switch (iEvent) {
            case 16: {
                break;
            }
            case 17: {
                this.LclMouseDown(paint0, iParam0, iParam1);
                break;
            }
            case 18: {
                this.LclMouseUp(paint0, iParam0, iParam1);
                break;
            }
            case 19: {
                this.LclMouseMove(paint0, iParam0, iParam1);
                break;
            }
            default: {
                return;
            }
        }
        SurfaceHolder holder = this.getHolder();
        Canvas canvas1 = holder.lockCanvas();
        if (canvas1 != null) {
            canvas1.scale(1.0f / this.m_fScaleX, 1.0f / this.m_fScaleY);
            canvas1.drawBitmap(this.m_Bmp, 0.0f, 0.0f, null);
            holder.unlockCanvasAndPost(canvas1);
        }
    }

    public void CameraOpen(int iCameraID, int iPixBytes, int iWidth, int iHeight, int iFrmRate, int iRotate, int iCameraNo) {
        Log.d((String)"pgnpp", (String)("CameraOpen, iWidth=" + iWidth + ", iHeight=" + iHeight + ", iFrmRate=" + iFrmRate + ", iRotate=" + iRotate + ", iCameraNo=" + iCameraNo));
        if (this.m_iType == 0) {
            this.m_iExtID = iCameraID;
            this.m_iProc = 0;
            this.m_iType = 1;
            this.m_iCameraPixBytes = iPixBytes;
            this.m_iCameraWidth = iWidth;
            this.m_iCameraHeight = iHeight;
            this.m_iCameraFrmRate = iFrmRate;
            this.m_iCameraRotate = iRotate;
            this.m_iCameraNo = iCameraNo;
            this.m_iCameraFacing = -1;
            if (this.getVisibility() != 8) {
                this.setVisibility(8);
            }
            this.setVisibility(0);
            return;
        }
        this.m_iCameraStaOpen = -1;
    }

    public void CameraClose() {
        Log.d((String)"pgnpp", (String)"CameraClose");
        if (this.m_iType == 1) {
            if (this.getVisibility() != 8) {
                this.setVisibility(8);
            } else {
                this.m_iCameraStaClose = -1;
            }
            this.getHolder().setType(0);
            this.m_iExtID = 0;
            this.m_iProc = 0;
            this.m_iType = 0;
            return;
        }
        this.m_iCameraStaClose = -1;
    }

    public void CameraSetStatus(int iMethod, int iStatus) {
        if (iMethod != 0) {
            this.m_iCameraStaOpen = iStatus;
        } else {
            this.m_iCameraStaClose = iStatus;
        }
    }

    public int CameraGetStatus(int iMethod) {
        if (iMethod != 0) {
            return this.m_iCameraStaOpen;
        }
        return this.m_iCameraStaClose;
    }

    public int CameraGetFormat() {
        return this.m_iCameraFormat;
    }

    public int CameraGetRotate() {
        if (this.m_iCameraFacing == 1) {
            return (360 - this.m_iCameraRotate) % 360;
        }
        return this.m_iCameraRotate;
    }

    public int CameraGetCameraNo() {
        return this.m_iCameraFacing;
    }

    public int CameraGetFacing() {
        if (this.m_iCameraFacing == 1) {
            return 1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean CameraStart(SurfaceHolder holder) {
        Log.d((String)"pgnpp", (String)"CameraStart");
        try {
            int iRateInput;
            if (this.m_Camera == null) {
                this.m_Camera = this.CameraDevice(this.m_iCameraWidth, this.m_iCameraHeight, this.m_iCameraNo);
                if (this.m_Camera == null) {
                    return false;
                }
            } else {
                this.m_Camera.stopPreview();
            }
            this.m_Camera.setPreviewDisplay(holder);
            Camera.Parameters Param = this.m_Camera.getParameters();
            List fmtList = this.m_Camera.getParameters().getSupportedPreviewFormats();
            int i = 0;
            while (i < fmtList.size()) {
                Log.d((String)"pgnpp", (String)("CameraStart: Format=" + fmtList.get(i)));
                ++i;
            }
            int iFmtSel = -1;
            int[] iFmtList = new int[]{17, 16, 20, 842094169};
            int i2 = 0;
            while (i2 < iFmtList.length) {
                int j = 0;
                while (j < fmtList.size()) {
                    if (iFmtList[i2] == (Integer)fmtList.get(j)) {
                        iFmtSel = iFmtList[i2];
                        break;
                    }
                    ++j;
                }
                if (iFmtSel >= 0) break;
                ++i2;
            }
            if (iFmtSel >= 0) {
                Log.d((String)"pgnpp", (String)("CameraStart: Param.setPreviewFormat, iFmtSel=" + iFmtSel));
                Param.setPreviewFormat(iFmtSel);
            } else {
                Log.d((String)"pgnpp", (String)"CameraStart: No validable preview format!");
            }
            Log.d((String)"pgnpp", (String)("CameraStart: Param.setPreviewSize: Width=" + this.m_iCameraWidth + ", Height=" + this.m_iCameraHeight));
            Param.setPreviewSize(this.m_iCameraWidth, this.m_iCameraHeight);
            int iRateSet = iRateInput = 1000 / this.m_iCameraFrmRate;
            int iDeltaMin = 65536;
            List listRate = this.m_Camera.getParameters().getSupportedPreviewFrameRates();
            int i3 = 0;
            while (i3 < listRate.size()) {
                int iRateTemp = (Integer)listRate.get(i3);
                int iDeltaTemp = iRateTemp - iRateInput;
                if (iDeltaTemp < 0) {
                    iDeltaTemp = -iDeltaTemp;
                }
                if (iDeltaTemp < iDeltaMin) {
                    iDeltaMin = iDeltaTemp;
                    iRateSet = iRateTemp;
                }
                Log.d((String)"pgnpp", (String)("CameraStart: Rate=" + iRateTemp));
                ++i3;
            }
            Log.d((String)"pgnpp", (String)("CameraStart: Param.setPreviewFrameRate, iRateSet=" + iRateSet));
            Param.setPreviewFrameRate(iRateSet);
            int iRotate = 0;
            iRotate = this.m_iCameraFacing == 1 ? this.m_iCameraRotate : this.m_iCameraRotate;
            if (iRotate != 0) {
                Param.set("rotation", iRotate);
                Log.d((String)"pgnpp", (String)("CameraStart: Set preview orientation: " + iRotate));
                this.m_Camera.setDisplayOrientation(iRotate);
            }
            this.m_Camera.setParameters(Param);
            Log.d((String)"pgnpp", (String)"CameraStart: setParameters");
            this.m_Camera.setPreviewCallback((Camera.PreviewCallback)this);
            Log.d((String)"pgnpp", (String)"CameraStart: setPreviewDisplay");
            this.m_Camera.startPreview();
            Log.d((String)"pgnpp", (String)"CameraStart: startPreview");
            this.m_iCameraFormat = this.m_Camera.getParameters().getPreviewFormat();
            if (this.m_iCameraFormat != iFmtSel) {
                Log.d((String)"pgnpp", (String)"CameraStart: Current format is no same to iFmtSel");
            }
            Log.d((String)"pgnpp", (String)("CameraStart: Current format=" + this.m_iCameraFormat));
            return true;
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("CameraStart Exception=" + ex.toString()));
            this.CameraStop();
            return false;
        }
    }

    private void CameraStop() {
        if (this.m_Camera != null) {
            Log.d((String)"pgnpp", (String)"CameraStop");
            this.m_Camera.setPreviewCallback(null);
            this.m_Camera.stopPreview();
            Log.d((String)"pgnpp", (String)"m_Camera.stopPreview");
            this.m_Camera.release();
            this.m_Camera = null;
            this.m_iCameraFormat = -1;
        }
    }

    private Camera CameraDevice(int iW, int iH, int iCameraNo) {
        Camera cameraTemp;
        int iCameraFacing;
        block13: {
            Log.d((String)"pgnpp", (String)"CameraDevice");
            iCameraFacing = -1;
            cameraTemp = null;
            int iCameraInd = -1;
            int iCameraIndFront = -1;
            int iInd = 0;
            while (iInd < Camera.getNumberOfCameras()) {
                Camera.CameraInfo info = new Camera.CameraInfo();
                Camera.getCameraInfo((int)iInd, (Camera.CameraInfo)info);
                if (info.facing == iCameraNo) {
                    iCameraInd = iInd;
                    iCameraFacing = iCameraNo;
                    Log.d((String)"pgnpp", (String)("CameraDevice: Select iCameraNo=" + iCameraNo));
                    break;
                }
                if (iCameraIndFront < 0 && info.facing == 1) {
                    iCameraIndFront = iInd;
                }
                ++iInd;
            }
            if (iCameraInd < 0 && iCameraIndFront >= 0) {
                iCameraInd = iCameraIndFront;
                iCameraFacing = 1;
                Log.d((String)"pgnpp", (String)"CameraDevice: Select front camera.");
            }
            if (iCameraInd >= 0) {
                cameraTemp = Camera.open((int)iCameraInd);
            }
            if (cameraTemp == null) {
                cameraTemp = Camera.open();
                iCameraFacing = 0;
            }
            if (cameraTemp != null) break block13;
            Log.e((String)"pgnpp", (String)"CameraDevice: Open device failed.");
            return null;
        }
        try {
            boolean bHasSizeMode = false;
            List sizeList = cameraTemp.getParameters().getSupportedPreviewSizes();
            int i = 0;
            while (i < sizeList.size()) {
                Camera.Size size = (Camera.Size)sizeList.get(i);
                if (size.width == iW && size.height == iH) {
                    bHasSizeMode = true;
                    break;
                }
                Log.d((String)"pgnpp", (String)("CameraDevice: Not match size: width=" + size.width + ", height=" + size.height));
                ++i;
            }
            if (!bHasSizeMode) {
                Log.d((String)"pgnpp", (String)"CameraDevice: Not find valid size mode");
                cameraTemp.release();
                cameraTemp = null;
            }
            this.m_iCameraFacing = iCameraFacing;
            return cameraTemp;
        }
        catch (Exception ex) {
            Log.e((String)"pgnpp", (String)("CameraDevice Exception=" + ex.toString()));
            if (cameraTemp != null) {
                cameraTemp.release();
            }
            return null;
        }
    }

    public int VideoAttach(int iVideoID, int iProc) {
        Log.d((String)"pgnpp", (String)"VideoAttach");
        if (this.m_iType == 0) {
            this.m_iExtID = iVideoID;
            this.m_iProc = iProc;
            this.m_iType = 2;
            this.m_iVideoWidth = 0;
            this.m_iVideoHeight = 0;
            this.m_iVideoMode = 0;
            return 1;
        }
        return 0;
    }

    public void VideoDetach() {
        Log.d((String)"pgnpp", (String)"VideoDetach");
        if (this.m_iType == 2) {
            this.VideoClean();
            this.m_iExtID = 0;
            this.m_iProc = 0;
            this.m_iType = 0;
            this.m_iVideoMode = 0;
        }
    }

    public boolean VideoInit(int iWidth, int iHeight) {
        try {
            if (this.m_PaintVideo == null) {
                this.m_PaintVideo = new Paint();
                this.m_PaintVideo.setAntiAlias(true);
                this.m_PaintVideo.setFilterBitmap(true);
            }
            if (this.m_BmpVideo == null) {
                this.m_BmpVideo = Bitmap.createBitmap((int)iWidth, (int)iHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
            }
            if (this.m_RectVideo == null) {
                this.m_RectVideo = new Rect(0, 0, iWidth, iHeight);
            }
            return true;
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysWnd.VideoInit: ex=" + ex.toString()));
            return false;
        }
    }

    public int VideoBufferAlloc(int iWidth, int iHeight) {
        block4: {
            try {
                if (this.m_iType == 2) break block4;
                return 0;
            }
            catch (Exception ex) {
                Log.d((String)"pgnpp", (String)("pgSysWnd.VideoBufferAlloc: ex=" + ex.toString()));
                return 0;
            }
        }
        int iSizeXY = iWidth * iHeight;
        if (iSizeXY != this.m_iVideoImgSize) {
            this.m_iVideoImgBuffer = new int[iSizeXY];
            this.m_iVideoImgSize = iSizeXY;
        }
        return 1;
    }

    public int VideoBitmap(int iPosX, int iPosY, int iWidth, int iHeight, int iFillMode) {
        SurfaceHolder holder;
        Canvas canvas;
        block24: {
            block23: {
                if (this.m_iType != 2) {
                    return 0;
                }
                int iSizeXY = iWidth * iHeight;
                if (this.m_iVideoImgBuffer.length < iSizeXY) {
                    Log.d((String)"pgnpp", (String)"pgSysWnd.VideoBitmap: m_iVideoImgBuffer length invalid.");
                    return 0;
                }
                if (iWidth != this.m_iVideoWidth || iHeight != this.m_iVideoHeight) {
                    this.m_iVideoWidth = iWidth;
                    this.m_iVideoHeight = iHeight;
                    this.m_iVideoFillCount = 4;
                    this.m_BmpVideo = null;
                }
                if (this.m_iVideoFillMode != iFillMode) {
                    this.m_iVideoFillMode = iFillMode;
                    this.m_iVideoFillCount = 4;
                }
                if (!this.VideoInit(iWidth, iHeight)) {
                    return 0;
                }
                canvas = null;
                holder = null;
                holder = this.getHolder();
                if (holder != null) break block23;
                return 0;
            }
            canvas = holder.lockCanvas();
            if (canvas != null) break block24;
            return 0;
        }
        try {
            if (this.m_iVideoFillCount > 0) {
                canvas.drawColor(-16777216);
                --this.m_iVideoFillCount;
            }
            int iPosX1 = 0;
            int iPosY1 = 0;
            int iWidth1 = 0;
            int iHeight1 = 0;
            if (iFillMode == 0) {
                if ((this.m_iWndWidth << 3) / this.m_iWndHeight > (iWidth << 3) / iHeight) {
                    iWidth1 = this.m_iWndWidth;
                    iHeight1 = (int)((float)this.m_iWndWidth * (float)iHeight / (float)iWidth);
                    iPosY1 = (this.m_iWndHeight - iHeight1) / 2;
                } else if ((this.m_iWndWidth << 3) / this.m_iWndHeight < (iWidth << 3) / iHeight) {
                    iWidth1 = (int)((float)this.m_iWndHeight * (float)iWidth / (float)iHeight);
                    iHeight1 = this.m_iWndHeight;
                    iPosX1 = (this.m_iWndWidth - iWidth1) / 2;
                } else {
                    iWidth1 = this.m_iWndWidth;
                    iHeight1 = this.m_iWndHeight;
                }
            } else if (iFillMode == 1) {
                if ((this.m_iWndWidth << 3) / this.m_iWndHeight > (iWidth << 3) / iHeight) {
                    iWidth1 = (int)((float)this.m_iWndHeight * (float)iWidth / (float)iHeight);
                    iHeight1 = this.m_iWndHeight;
                    iPosX1 = (this.m_iWndWidth - iWidth1) / 2;
                } else if ((this.m_iWndWidth << 3) / this.m_iWndHeight < (iWidth << 3) / iHeight) {
                    iWidth1 = this.m_iWndWidth;
                    iHeight1 = (int)((float)this.m_iWndWidth * (float)iHeight / (float)iWidth);
                    iPosY1 = (this.m_iWndHeight - iHeight1) / 2;
                } else {
                    iWidth1 = this.m_iWndWidth;
                    iHeight1 = this.m_iWndHeight;
                }
            } else {
                iWidth1 = this.m_iWndWidth;
                iHeight1 = this.m_iWndHeight;
            }
            this.m_BmpVideo.setPixels(this.m_iVideoImgBuffer, 0, iWidth, 0, 0, iWidth, iHeight);
            this.m_RectVideo.set(iPosX1, iPosY1, iPosX1 + iWidth1, iPosY1 + iHeight1);
            canvas.drawBitmap(this.m_BmpVideo, null, this.m_RectVideo, this.m_PaintVideo);
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysWnd.VideoBitmap: ex=" + ex.toString()));
        }
        if (holder != null && canvas != null) {
            holder.unlockCanvasAndPost(canvas);
        }
        return 1;
    }

    public void VideoClean() {
        Canvas canvas = null;
        SurfaceHolder holder = null;
        try {
            if (this.m_iVideoMode == 2 && (canvas = (holder = this.getHolder()).lockCanvas()) != null) {
                canvas.drawColor(-16777216);
            }
        }
        catch (Exception ex) {
            Log.d((String)"pgnpp", (String)("pgSysWnd.VideoClean: ex=" + ex.toString()));
        }
        if (holder != null && canvas != null) {
            holder.unlockCanvasAndPost(canvas);
        }
    }

    public Surface VideoModeGL(int iEnable) {
        try {
            Surface surfaceCur = null;
            if (iEnable != 0) {
                surfaceCur = this.getHolder().getSurface();
                this.m_iVideoMode = surfaceCur != null ? 1 : 2;
            } else {
                this.m_iVideoMode = 2;
                this.VideoClean();
            }
            Log.d((String)"pgnpp", (String)("pgSysWnd.VideoModeGL: iVideoMode=" + this.m_iVideoMode));
            return surfaceCur;
        }
        catch (Exception ex) {
            this.m_iVideoMode = 2;
            Log.d((String)"pgnpp", (String)("pgSysWnd.VideoModeGL: ex=" + ex.toString()));
            return null;
        }
    }

    public int VideoHasSurface() {
        return this.m_iVideoHasSurface;
    }

    public int BoardAttach(int iBoardID, int iProc) {
        Log.d((String)"pgnpp", (String)"BoardAttach");
        if (this.m_iType == 0) {
            this.m_iExtID = iBoardID;
            this.m_iProc = iProc;
            this.m_iType = 3;
            this.PostDraw();
            return 1;
        }
        return 0;
    }

    public void BoardDetach() {
        Log.d((String)"pgnpp", (String)"BoardDetach");
        if (this.m_iType == 3) {
            this.PostClean();
            this.m_iExtID = 0;
            this.m_iProc = 0;
            this.m_iType = 0;
        }
    }

    public int BoardDraw(int iShape, int iColor, int iWidth, int iType, int iStatus, float[] PntList) {
        if (this.m_iProc == 0 || this.m_iType != 3) {
            return 0;
        }
        String strTemp = String.format("BoardDraw, iShape=%d, iColor=0x%x, iWidth=%d, iStatus=%d, PntSize=%d", iShape, iColor, iWidth, iStatus, PntList.length);
        Log.d((String)"pgnpp", (String)strTemp);
        if (!this.InitBitmap()) {
            return 0;
        }
        this.m_iRmtColor = iColor | 0xFF000000;
        this.m_iRmtWidth = iWidth;
        this.m_iRmtType = iType;
        Paint paint0 = this.NewPaint(this.m_iRmtColor, this.m_iRmtWidth, this.m_iRmtType);
        Canvas canvas = new Canvas(this.m_Bmp);
        if (this.m_iRmtShape != iShape) {
            if (this.m_iRmtShape == 5) {
                this.RmtDrawPointer(canvas, paint0, PntList, false);
            }
            this.m_iPosLastX = 0;
            this.m_iPosLastY = 0;
        }
        this.m_iRmtShape = iShape;
        switch (this.m_iRmtShape) {
            case 1: {
                this.RmtDrawPen(canvas, paint0, PntList, iStatus);
                break;
            }
            case 2: {
                this.RmtDrawLine(canvas, paint0, PntList);
                break;
            }
            case 3: {
                this.RmtDrawRectangle(canvas, paint0, PntList);
                break;
            }
            case 4: {
                this.RmtDrawEllipse(canvas, paint0, PntList);
                break;
            }
            case 5: {
                this.RmtDrawPointer(canvas, paint0, PntList, true);
                break;
            }
            default: {
                return 1;
            }
        }
        SurfaceHolder holder = this.getHolder();
        Canvas canvas1 = holder.lockCanvas();
        if (canvas1 != null) {
            canvas1.scale(1.0f / this.m_fScaleX, 1.0f / this.m_fScaleY);
            canvas1.drawBitmap(this.m_Bmp, 0.0f, 0.0f, null);
            holder.unlockCanvasAndPost(canvas1);
        }
        return 1;
    }

    public int BoardSetShape(int iDirect, int iShape, int iColor, int iWidth, int iType) {
        Log.d((String)"pgnpp", (String)"BoardSetShape");
        if (iDirect != 0) {
            this.m_iLclShape = iShape;
            this.m_iLclColor = iColor | 0xFF000000;
            this.m_iLclWidth = iWidth;
            this.m_iLclType = iType;
        } else {
            this.m_iRmtShape = iShape;
            this.m_iRmtColor = iColor | 0xFF000000;
            this.m_iRmtWidth = iWidth;
            this.m_iRmtType = iType;
        }
        return 1;
    }

    public int BoardSetCursor(int iShape, String strPath) {
        Log.d((String)"pgnpp", (String)"BoardSetCursor");
        return 1;
    }

    public int BoardSave(String strPath) {
        FileOutputStream file;
        block3: {
            String strTemp = String.format("BoardSave, strPath=%s", strPath);
            Log.d((String)"pgnpp", (String)strTemp);
            try {
                file = new FileOutputStream(strPath);
                if (!this.m_Bmp.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)file)) break block3;
                file.close();
                return 1;
            }
            catch (Exception ex) {
                return 0;
            }
        }
        file.close();
        return 0;
    }

    public int BoardLoad(String strPath) {
        String strTemp = String.format("BoardLoad, strPath=%s", strPath);
        Log.d((String)"pgnpp", (String)strTemp);
        int iRet = 0;
        Bitmap bmp = BitmapFactory.decodeFile((String)strPath);
        if (bmp != null) {
            this.m_Bmp = bmp.copy(Bitmap.Config.ARGB_8888, true);
            SurfaceHolder holder = this.getHolder();
            Canvas canvas = holder.lockCanvas();
            if (canvas != null) {
                canvas.scale(1.0f / this.m_fScaleX, 1.0f / this.m_fScaleY);
                canvas.drawBitmap(this.m_Bmp, 0.0f, 0.0f, null);
                holder.unlockCanvasAndPost(canvas);
                iRet = 1;
            }
        }
        return iRet;
    }

    private void BoardReport(int iStatus, int[] PntList, int iPntSize) {
        if (this.m_iProc != 0) {
            pgSysJNI.WndBoardOnReport(this.m_iProc, this.m_iExtID, iStatus, PntList, iPntSize);
        }
    }

    private boolean InitBitmap() {
        if (this.m_Bmp == null) {
            Log.d((String)"pgnpp", (String)"InitBitmap 0");
            this.m_Bmp = Bitmap.createBitmap((int)this.m_iWidth, (int)this.m_iHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (this.m_Bmp == null) {
                Log.d((String)"pgnpp", (String)"InitBitmap false");
                return false;
            }
            Canvas canvas = new Canvas(this.m_Bmp);
            if (canvas != null) {
                Log.d((String)"pgnpp", (String)"InitBitmap drawRGB");
                canvas.drawRGB(255, 255, 255);
            }
        }
        return true;
    }

    private Paint NewPaint(int iColor, int iWidth, int iType) {
        Paint paint0 = new Paint();
        paint0.setStyle(Paint.Style.STROKE);
        paint0.setColor(iColor);
        paint0.setStrokeWidth((float)iWidth);
        paint0.setStrokeCap(Paint.Cap.ROUND);
        return paint0;
    }

    private void RmtDrawPen(Canvas canvas, Paint paint, float[] PntList, int iStatus) {
        int iEndY;
        int iEndX;
        if (PntList.length < 4) {
            return;
        }
        int iInd = 0;
        if (this.m_iPosLastX != 0 || this.m_iPosLastY != 0) {
            iEndX = this.m_iPosLastX;
            iEndY = this.m_iPosLastY;
        } else {
            iEndX = (int)PntList[0];
            iEndY = (int)PntList[1];
            iInd = 1;
        }
        int iPointNum = PntList.length / 2;
        while (iInd < iPointNum) {
            int iPosX = iEndX;
            int iPosY = iEndY;
            iEndX = (int)PntList[iInd * 2 + 0];
            iEndY = (int)PntList[iInd * 2 + 1];
            canvas.drawLine((float)iPosX, (float)iPosY, (float)iEndX, (float)iEndY, paint);
            ++iInd;
        }
        if (iStatus == 0) {
            this.m_iPosLastX = iEndX;
            this.m_iPosLastY = iEndY;
        } else {
            this.m_iPosLastX = 0;
            this.m_iPosLastY = 0;
        }
    }

    private void RmtDrawLine(Canvas canvas, Paint paint, float[] PntList) {
        if (PntList.length == 4) {
            canvas.drawLine(PntList[0], PntList[1], PntList[2], PntList[3], paint);
        }
    }

    private void RmtDrawRectangle(Canvas canvas, Paint paint, float[] PntList) {
        if (PntList.length == 4) {
            canvas.drawRect(PntList[0], PntList[1], PntList[2], PntList[3], paint);
        }
    }

    private void RmtDrawEllipse(Canvas canvas, Paint paint, float[] PntList) {
        if (PntList.length == 4) {
            RectF ovl = new RectF(PntList[0], PntList[1], PntList[2], PntList[3]);
            canvas.drawArc(ovl, 0.0f, 360.0f, false, paint);
        }
    }

    private void RmtDrawPointer(Canvas canvas, Paint paint, float[] PntList, boolean bNew) {
        paint.setXfermode((Xfermode)this.m_ModeXOR);
        float[] Pnt = new float[12];
        if (this.m_iPosLastX != 0 || this.m_iPosLastY != 0) {
            Pnt[0] = this.m_iPosLastX;
            Pnt[1] = this.m_iPosLastY;
            Pnt[2] = Pnt[0] + 10.0f;
            Pnt[3] = Pnt[1] + 10.0f;
            Pnt[4] = Pnt[2];
            Pnt[5] = Pnt[3];
            Pnt[6] = Pnt[0];
            Pnt[7] = Pnt[1] + 14.0f;
            Pnt[8] = Pnt[6];
            Pnt[9] = Pnt[7];
            Pnt[10] = this.m_iPosLastX;
            Pnt[11] = this.m_iPosLastY;
            canvas.drawLines(Pnt, 0, 12, paint);
        }
        if (bNew && PntList.length == 2) {
            Pnt[0] = PntList[0];
            Pnt[1] = PntList[1];
            Pnt[2] = Pnt[0] + 10.0f;
            Pnt[3] = Pnt[1] + 10.0f;
            Pnt[4] = Pnt[2];
            Pnt[5] = Pnt[3];
            Pnt[6] = Pnt[0];
            Pnt[7] = Pnt[1] + 14.0f;
            Pnt[8] = Pnt[6];
            Pnt[9] = Pnt[7];
            Pnt[10] = PntList[0];
            Pnt[11] = PntList[1];
            canvas.drawLines(Pnt, 0, 12, paint);
            this.m_iPosLastX = (int)PntList[0];
            this.m_iPosLastY = (int)PntList[1];
        } else {
            this.m_iPosLastX = 0;
            this.m_iPosLastY = 0;
        }
    }

    private void LclMouseMove(Paint paint, int x, int y) {
        Canvas canvas = new Canvas(this.m_Bmp);
        if (canvas != null) {
            switch (this.m_iLclShape) {
                case 1: {
                    this.LclMouseMovePen(canvas, paint, x, y);
                    break;
                }
                case 2: {
                    this.LclMouseMoveLine(canvas, paint, x, y);
                    break;
                }
                case 3: {
                    this.LclMouseMoveRectangle(canvas, paint, x, y);
                    break;
                }
                case 4: {
                    this.LclMouseMoveEllipse(canvas, paint, x, y);
                    break;
                }
                case 5: {
                    this.LclMouseMovePointer(canvas, paint, x, y);
                }
            }
        }
    }

    private void LclMouseUp(Paint paint, int x, int y) {
        Canvas canvas;
        this.m_iMouseStatus = 0;
        if (this.m_iMouseTrack != 0) {
            this.m_iMouseTrack = 0;
        }
        if ((canvas = new Canvas(this.m_Bmp)) != null) {
            switch (this.m_iLclShape) {
                case 1: {
                    this.LclMouseUpPen(canvas, paint, x, y);
                    break;
                }
                case 2: {
                    this.LclMouseUpLine(canvas, paint, x, y);
                    break;
                }
                case 3: {
                    this.LclMouseUpRectangle(canvas, paint, x, y);
                    break;
                }
                case 4: {
                    this.LclMouseUpEllipse(canvas, paint, x, y);
                    break;
                }
                case 5: {
                    this.LclMouseUpPointer(canvas, paint, x, y);
                }
            }
        }
        this.m_iPntInd = 0;
        this.m_iPosPrevX = 0;
        this.m_iPosPrevY = 0;
    }

    private void LclMouseDown(Paint paint, int x, int y) {
        if (this.m_iMouseTrack == 0) {
            this.m_iMouseTrack = 1;
        }
        this.m_iPosDownX = x;
        this.m_iPosDownY = y;
        this.m_iMouseStatus = 1;
        this.m_iPosPrevX = x;
        this.m_iPosPrevY = y;
        this.m_iPntInd = 0;
        this.m_iPntInput[this.m_iPntInd * 2] = x;
        this.m_iPntInput[this.m_iPntInd * 2 + 1] = y;
        ++this.m_iPntInd;
    }

    private void LclMouseMovePen(Canvas canvas, Paint paint, int x, int y) {
        if (this.m_iMouseStatus == 0) {
            return;
        }
        canvas.drawLine((float)this.m_iPosPrevX, (float)this.m_iPosPrevY, (float)x, (float)y, paint);
        this.m_iPntInput[this.m_iPntInd * 2 + 0] = x;
        this.m_iPntInput[this.m_iPntInd * 2 + 1] = y;
        ++this.m_iPntInd;
        if (this.m_iPntInd >= 8) {
            this.BoardReport(0, this.m_iPntInput, this.m_iPntInd * 2);
            this.m_iPntInd = 0;
        }
        this.m_iPosPrevX = x;
        this.m_iPosPrevY = y;
    }

    private void LclMouseMoveLine(Canvas canvas, Paint paint, int x, int y) {
        if (this.m_iMouseStatus == 0) {
            return;
        }
        paint.setXfermode((Xfermode)this.m_ModeXOR);
        canvas.drawLine((float)this.m_iPosDownX, (float)this.m_iPosDownY, (float)this.m_iPosPrevX, (float)this.m_iPosPrevY, paint);
        canvas.drawLine((float)this.m_iPosDownX, (float)this.m_iPosDownY, (float)x, (float)y, paint);
        this.m_iPosPrevX = x;
        this.m_iPosPrevY = y;
    }

    private void LclMouseMoveRectangle(Canvas canvas, Paint paint, int x, int y) {
        if (this.m_iMouseStatus == 0) {
            return;
        }
        paint.setXfermode((Xfermode)this.m_ModeXOR);
        canvas.drawRect((float)this.m_iPosDownX, (float)this.m_iPosDownY, (float)this.m_iPosPrevX, (float)this.m_iPosPrevY, paint);
        canvas.drawRect((float)this.m_iPosDownX, (float)this.m_iPosDownY, (float)x, (float)y, paint);
        this.m_iPosPrevX = x;
        this.m_iPosPrevY = y;
    }

    private void LclMouseMoveEllipse(Canvas canvas, Paint paint, int x, int y) {
        if (this.m_iMouseStatus == 0) {
            return;
        }
        paint.setXfermode((Xfermode)this.m_ModeXOR);
        RectF ovl = new RectF((float)this.m_iPosDownX, (float)this.m_iPosDownY, (float)this.m_iPosPrevX, (float)this.m_iPosPrevY);
        canvas.drawArc(ovl, 0.0f, 360.0f, false, paint);
        RectF ovl1 = new RectF((float)this.m_iPosDownX, (float)this.m_iPosDownY, (float)x, (float)y);
        canvas.drawArc(ovl1, 0.0f, 360.0f, false, paint);
        this.m_iPosPrevX = x;
        this.m_iPosPrevY = y;
    }

    private void LclMouseMovePointer(Canvas canvas, Paint paint, int x, int y) {
        paint.setXfermode((Xfermode)this.m_ModeXOR);
        float[] Pnt = new float[12];
        if (this.m_iPosTempX != 0 || this.m_iPosTempY != 0) {
            Pnt[0] = this.m_iPosTempX;
            Pnt[1] = this.m_iPosTempY;
            Pnt[2] = Pnt[0] + 10.0f;
            Pnt[3] = Pnt[1] + 10.0f;
            Pnt[4] = Pnt[2];
            Pnt[5] = Pnt[3];
            Pnt[6] = Pnt[0];
            Pnt[7] = Pnt[1] + 14.0f;
            Pnt[8] = Pnt[6];
            Pnt[9] = Pnt[7];
            Pnt[10] = this.m_iPosTempX;
            Pnt[11] = this.m_iPosTempY;
            canvas.drawLines(Pnt, 0, 12, paint);
        }
        if (this.m_iMouseTrack != 0) {
            Pnt[0] = x;
            Pnt[1] = y;
            Pnt[2] = Pnt[0] + 10.0f;
            Pnt[3] = Pnt[1] + 10.0f;
            Pnt[4] = Pnt[2];
            Pnt[5] = Pnt[3];
            Pnt[6] = Pnt[0];
            Pnt[7] = Pnt[1] + 14.0f;
            Pnt[8] = Pnt[6];
            Pnt[9] = Pnt[7];
            Pnt[10] = x;
            Pnt[11] = y;
            canvas.drawLines(Pnt, 0, 12, paint);
            this.m_iPosTempX = x;
            this.m_iPosTempY = y;
            this.m_iPntInput[0] = x;
            this.m_iPntInput[1] = y;
            this.BoardReport(1, this.m_iPntInput, 2);
        } else {
            this.m_iPosTempX = 0;
            this.m_iPosTempY = 0;
        }
    }

    private void LclMouseUpPen(Canvas canvas, Paint paint, int x, int y) {
        canvas.drawLine((float)this.m_iPosPrevX, (float)this.m_iPosPrevY, (float)x, (float)y, paint);
        this.m_iPntInput[this.m_iPntInd * 2 + 0] = x;
        this.m_iPntInput[this.m_iPntInd * 2 + 1] = y;
        ++this.m_iPntInd;
        this.BoardReport(1, this.m_iPntInput, this.m_iPntInd * 2);
    }

    private void LclMouseUpLine(Canvas canvas, Paint paint, int x, int y) {
        paint.setXfermode((Xfermode)this.m_ModeXOR);
        canvas.drawLine((float)this.m_iPosDownX, (float)this.m_iPosDownY, (float)this.m_iPosPrevX, (float)this.m_iPosPrevY, paint);
        paint.setXfermode((Xfermode)this.m_ModeSRC);
        canvas.drawLine((float)this.m_iPosDownX, (float)this.m_iPosDownY, (float)x, (float)y, paint);
        this.m_iPntInput[this.m_iPntInd * 2 + 0] = x;
        this.m_iPntInput[this.m_iPntInd * 2 + 1] = y;
        ++this.m_iPntInd;
        this.BoardReport(1, this.m_iPntInput, this.m_iPntInd * 2);
    }

    private void LclMouseUpRectangle(Canvas canvas, Paint paint, int x, int y) {
        paint.setXfermode((Xfermode)this.m_ModeXOR);
        canvas.drawRect((float)this.m_iPosDownX, (float)this.m_iPosDownY, (float)this.m_iPosPrevX, (float)this.m_iPosPrevY, paint);
        paint.setXfermode((Xfermode)this.m_ModeSRC);
        canvas.drawRect((float)this.m_iPosDownX, (float)this.m_iPosDownY, (float)x, (float)y, paint);
        this.m_iPntInput[this.m_iPntInd * 2 + 0] = x;
        this.m_iPntInput[this.m_iPntInd * 2 + 1] = y;
        ++this.m_iPntInd;
        this.BoardReport(1, this.m_iPntInput, this.m_iPntInd * 2);
    }

    private void LclMouseUpEllipse(Canvas canvas, Paint paint, int x, int y) {
        paint.setXfermode((Xfermode)this.m_ModeXOR);
        RectF ovl = new RectF((float)this.m_iPosDownX, (float)this.m_iPosDownY, (float)this.m_iPosPrevX, (float)this.m_iPosPrevY);
        canvas.drawArc(ovl, 0.0f, 360.0f, false, paint);
        paint.setXfermode((Xfermode)this.m_ModeSRC);
        RectF ovl1 = new RectF((float)this.m_iPosDownX, (float)this.m_iPosDownY, (float)x, (float)y);
        canvas.drawArc(ovl1, 0.0f, 360.0f, false, paint);
        this.m_iPntInput[this.m_iPntInd * 2 + 0] = x;
        this.m_iPntInput[this.m_iPntInd * 2 + 1] = y;
        ++this.m_iPntInd;
        this.BoardReport(1, this.m_iPntInput, this.m_iPntInd * 2);
    }

    private void LclMouseUpPointer(Canvas canvas, Paint paint, int x, int y) {
        if (this.m_iPosTempX != 0 || this.m_iPosTempX != 0) {
            float[] Pnt = new float[12];
            paint.setXfermode((Xfermode)this.m_ModeXOR);
            Pnt[0] = this.m_iPosTempX;
            Pnt[1] = this.m_iPosTempY;
            Pnt[2] = Pnt[0] + 10.0f;
            Pnt[3] = Pnt[1] + 10.0f;
            Pnt[4] = Pnt[2];
            Pnt[5] = Pnt[3];
            Pnt[6] = Pnt[0];
            Pnt[7] = Pnt[1] + 14.0f;
            Pnt[8] = Pnt[6];
            Pnt[9] = Pnt[7];
            Pnt[10] = this.m_iPosTempX;
            Pnt[11] = this.m_iPosTempY;
            canvas.drawLines(Pnt, 0, 12, paint);
        }
        this.m_iPosTempX = 0;
        this.m_iPosTempY = 0;
        this.BoardReport(1, this.m_iPntInput, 0);
    }

    protected void onDrawProc(Canvas canvas) {
        if (this.m_iType == 3) {
            canvas.drawColor(-1);
            pgSysJNI.WndEventProc(this.m_iWndID, 16, 0, 0);
        } else if (this.m_iType == 2) {
            canvas.drawColor(-16777216);
        } else if (this.m_iType == 1) {
            canvas.drawColor(-16777216);
        } else {
            canvas.drawColor(-16777216);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.m_iProc == 0 || this.m_iType != 3) {
            return false;
        }
        int iPGEvent = 0;
        int iEvent = event.getActionMasked() & 0xFF;
        switch (iEvent) {
            case 0: {
                iPGEvent = 17;
                break;
            }
            case 1: {
                iPGEvent = 18;
                break;
            }
            case 2: {
                iPGEvent = 19;
                break;
            }
            default: {
                return false;
            }
        }
        float fX = event.getX() * this.m_fScaleX;
        float fY = event.getY() * this.m_fScaleY;
        pgSysJNI.WndEventProc(this.m_iWndID, iPGEvent, (int)fX, (int)fY);
        return true;
    }

    public boolean onTrackballEvent(MotionEvent event) {
        return this.onTouchEvent(event);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Log.d((String)"pgnpp", (String)"surfaceCreated");
        this.m_iVideoHasSurface = 1;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.m_iWndWidth = width;
        this.m_iWndHeight = height;
        this.m_fScaleX = (float)this.m_iWidth / (float)width;
        this.m_fScaleY = (float)this.m_iHeight / (float)height;
        String strTemp = String.format("surfaceChanged, format=%d, width=%d, height=%d, ScaleX=%f, ScaleY=%f", format, width, height, Float.valueOf(this.m_fScaleX), Float.valueOf(this.m_fScaleY));
        Log.d((String)"pgnpp", (String)strTemp);
        if (this.m_iType == 1) {
            this.m_iCameraStaOpen = this.CameraStart(holder) ? 1 : -1;
        } else if (this.m_iType == 3) {
            this.PostDraw();
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        Log.d((String)"pgnpp", (String)"surfaceDestroyed");
        this.CameraStop();
        this.m_iCameraStaClose = 1;
        this.m_iVideoHasSurface = 0;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        if (this.m_iType == 1) {
            pgSysJNI.VideoInOnCapture(this.m_iExtID, data, data.length);
        }
    }

    public int FlashLight(int iEnable) {
        block3: {
            try {
                boolean bEnable;
                boolean bl = bEnable = iEnable != 0;
                if (!this.PostRunnable(new FlashLighRunnable(bEnable), 0)) break block3;
                return 1;
            }
            catch (Exception ex) {
                Log.d((String)"pgnpp", (String)("pgSysWnd.FlashLight: ex=" + ex.toString()));
                return 0;
            }
        }
        Log.d((String)"pgnpp", (String)"pgSysWnd.FlashLight: failed");
        return 0;
    }

    private void FlashLightHandle(boolean bEnable) {
        try {
            Log.d((String)"pgnpp", (String)("pgSysWnd.FlashLightHandle: bEnable=" + bEnable));
            if (this.m_Camera != null) {
                Camera.Parameters Param = this.m_Camera.getParameters();
                if (bEnable) {
                    Param.setFlashMode("torch");
                } else {
                    Param.setFlashMode("off");
                }
                this.m_Camera.setParameters(Param);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class FlashLighRunnable
    implements Runnable {
        private boolean m_bEnable = false;

        public FlashLighRunnable(boolean bEnable) {
            this.m_bEnable = bEnable;
        }

        @Override
        public void run() {
            pgSysWnd.this.FlashLightHandle(this.m_bEnable);
        }
    }
}

