package com.peergine.android.conference;

import com.peergine.plugin.lib.pgLibJNINode;

import static com.peergine.android.conference.OnEventConst.EVENT_LAN_SCAN_RESULT;
import static com.peergine.android.conference.pgLibConference2._OutString;
import static com.peergine.android.conference.pgLibError.PG_ERR_Busy;
import static com.peergine.android.conference.pgLibError.PG_ERR_System;
import static com.peergine.android.conference.pgLibNode.PG_METH_COMMON_SetOption;
import static com.peergine.android.conference.pgLibNode.PG_METH_PEER_LanScan;
import static com.peergine.android.conference.pgLibNode.addrToReadable;

public class ConferenceLanScan {

    private String ID_PREFIX = "";

    boolean bApiLanScan = false;
    String sLanScanRes = "";
    String sLanAddr;
    boolean bPeerCheckTimer = false;

    pgLibJNINode m_Node = null;

    private OnEventListener m_OnEventListener = null;
    private String m_sObjSvrName = "";

    private void _OnEvent(String sAct,String sData,String sPeer,String sConfName,String sEventParam){
        if(m_OnEventListener !=null){
            m_OnEventListener.event(sAct,sData,sPeer,sConfName,sEventParam);
        }
    }

    public int Initialize(pgLibJNINode Node ,String sObjSvrName,OnEventListener onEventListener){
        m_Node = Node;
        m_OnEventListener = onEventListener;
        m_sObjSvrName = sObjSvrName;
        String sValue = "(Enable){1}(Peer){" + m_Node.omlEncode(sObjSvrName) + "}(Label){pgConf}";
        String sData = "(Item){1}(Value){" + m_Node.omlEncode(sValue) + "}";
        return m_Node.ObjectRequest(sObjSvrName, PG_METH_COMMON_SetOption, sData, "EnableLanScan");
    }


    public void UpdateSvrName(String sObjSvrName){
        m_sObjSvrName = sObjSvrName;
    }

    public int Add(String sObjPeer){

       return 0;
    }

    public void Delete(String sObjPeer){


    }

    public int LanScanStart(){
        if(m_Node == null){
            return PG_ERR_System;
        }

        if(bApiLanScan) {
            return PG_ERR_Busy;
        }

        int iErr = m_Node.ObjectRequest(m_sObjSvrName, PG_METH_PEER_LanScan , "(Timeout){5}", "LanScan");
        if (iErr > 0) {
            _OutString("LanScanStart: iErr=" + iErr);
        } else {
            bApiLanScan = true;
        }


        return iErr;
    }

    public void _OnLanScanStart(String sObj , String sData){
        if (m_Node == null) {
            return;
        }

        this.sLanScanRes = "";

        int iInd = 0;
        while (true) {
            String sEle = m_Node.omlGetEle(sData, "PeerList.", 1, iInd);
            if ("".equals(sEle)) {
                break;
            }

            String sPeer = m_Node.omlGetName(sEle, "");
            int iPos = sPeer.indexOf(ID_PREFIX);
            if (iPos == 0) {
                String sAddr = m_Node.omlGetContent(sEle, ".Addr");
                if (bApiLanScan) {
                    String sID = sPeer.substring(5);
                    String sDataTemp = "id=" + sID + "&addr=" + sAddr;
                    _OnEvent(EVENT_LAN_SCAN_RESULT, sDataTemp, "","","");
                }
                this.sLanScanRes += ("(" + sPeer + "){" + sAddr + "}");
            }

            iInd++;
        }

        bApiLanScan = false;
    }


}
