/****************************************************************
  copyright   : Copyright (C) 2013, chenbichao,
              : All rights reserved.
              : www.pptun.com, www.peergine.com
              : 
  filename    : pgLibConnect.h
  discription : 
  modify      : create, chenbichao, 2013/11/10
              :
			  : modify, chenbichao, 2013/12/18
			  : 1. pgEvent()uTimeoutΪ0ʱȴء
			  :
			  : modify, chenbichao, 2013/12/30
			  : 1. pgEvent()ӿںϱߺ¼
			  :
			  : modify, chenbichao, 2014/03/17
			  : 1. PG_INIT_CFG_SṹuTryP2PTimeoutԣָP2P͸ĳʱʱ䡣
			  :
			  : modify, chenbichao, 2014/03/26
			  : 1. PG_EVENT_OFFLINE¼ָʱԶ˲ߡ
			  :
			  : modify, chenbichao, 2014/04/01
			  : 1. PG_EVENT_INFO¼ָʾ˻Զ˵NATַ͡Ϣ״̬
			  : 2. ӡPG_CNNT_Eö٣ʾӵͣNATͣ
			  : 3. ṹPG_INFO_SuIsForwardԸΪuCnntTypeʾ͡
			  :
			  : modify, chenbichao, 2014/04/02
			  : 1. pgLevel()ӿں͹رղͬ־
			  :
			  : modify, chenbichao, 2014/05/22
			  : 1. PG_CNNT_IPV4_PeerFwdͣP2Pڵת
			  : 2. PG_INIT_CFG_SṹuAllowForwardԣP2Pڵڵת
			  :
			  : modify, chenbichao, 2014/05/30
			  : 1. PG_INIT_CFG_SṹuAllowForwardԸΪuForwardSpeedתĴơ
			  :
			  : modify, chenbichao, 2014/10/29
			  : 1. PG_EVENT_LAN_SCAN¼ʾP2Pڵˡ
			  : 2. PG_LAN_SCAN_SݽṹȡP2PڵĽ
			  : 3. pgLanScanStart()ڵP2Pڵ
			  : 4. pgLanScanResult()ȡڵP2PڵĽ
			  :
			  : modify, chenbichao, 2015/01/18
			  : 1. PG_INIT_CFG_SṹuSessTimeoutԵȱʡֵΪ30
			  :
			  : modify, chenbichao, 2015/03/30
			  : 1. PG_NET_MODE_Eѡ緽ʽö١
			  : 2. pgServerNetMode()лP2P緽ʽ
			  : 
			  : modify, chenbichao, 2015/04/21
			  : 1. PG_INFO_SṹszListenIDԣȡ˵ID
			  : 2. ޸PG_LAN_SCAN_SṹszPeerIDΪszListenID塣
			  : 3. pgConnected()жϻỰûɡ
			  : 
			  : modify, chenbichao, 2015/12/12
			  : 1. PG_INIT_CFG_SṹuForwardUseԣǷʹõ3P2Pڵת
			  : 2. ޸PG_INIT_CFG_SṹuParamΪvoidָͣԼ64bitʹó
			  : 3. pgPeek()ɲ鿴ǰҪյݵĳȺȼ
			  : 
*****************************************************************/
#ifndef _PG_LIB_CONNECT_H
#define _PG_LIB_CONNECT_H


#ifdef __cplusplus
extern "C" {
#endif


/**
 *  ģʽͻ˻
 */
typedef enum tagPG_MODE_E {
	PG_MODE_CLIENT,   // ͻ
	PG_MODE_LISTEN,   // ˣͨ豸ˣ
	PG_MODE_BUTT,
} PG_MODE_E;


/**
 *  붨
 */
typedef enum tagPG_ERROR_E {
	PG_ERROR_OK = 0,             // ɹ
	PG_ERROR_INIT = -1,          // ûеpgInitialize()ѾpgCleanup()ģ顣
	PG_ERROR_CLOSE = -2,         // ỰѾرգỰѾɻָ
	PG_ERROR_BADPARAM = -3,      // ݵĲ
	PG_ERROR_NOBUF = -4,         // Ựͻ
	PG_ERROR_NODATA = -5,        // Ựûݵ
	PG_ERROR_NOSPACE = -6,       // ݵĽջ̫С
	PG_ERROR_TIMEOUT = -7,       // ʱ
	PG_ERROR_BUSY = -8,          // ϵͳæ
	PG_ERROR_NOLOGIN = -9,       // ûе¼P2P
	PG_ERROR_MAXSESS = -10,      // Ự
	PG_ERROR_NOCONNECT = -11,    // Ựû
	PG_ERROR_MAXINST = -12,      // ʵ
	PG_ERROR_SYSTEM = -127,      // ϵͳ
} PG_ERROR_E;


/**
 *  pgEvent()ȴ¼
 */
typedef enum tagPG_EVENT_E {
	PG_EVENT_NULL = 0,                   // NULL
	PG_EVENT_CONNECT = 1,                // ỰӳɹˣԵpgWrite()ݡ
	PG_EVENT_CLOSE = 2,                  // ỰԶ˹رգҪpgClose()ܳͷŻỰԴ
	PG_EVENT_WRITE = 3,                  // Ựĵײ㷢ͻĿпռˣԵpgWrite()ݡ
	PG_EVENT_READ = 4,                   // ỰĵײջݵԵpgRead()ݡ
	PG_EVENT_OFFLINE = 5,                // ỰĶԶ˲ˣpgOpen()Զ˲ߣϱ¼
	PG_EVENT_INFO = 6,                   // ỰӷʽNATͼб仯ˣԵpgInfo()ȡµϢ

	PG_EVENT_SVR_LOGIN = 16,             // ¼P2Pɹߣ
	PG_EVENT_SVR_LOGOUT = 17,            // P2Pעߣߣ
	PG_EVENT_SVR_REPLY = 18,             // P2PӦ¼ԵpgServerReply()Ӧ
	PG_EVENT_SVR_NOTIFY = 19,            // P2P¼ԵpgServerNotify()͡
	PG_EVENT_SVR_ERROR = 20,             // pgServerRequestش
	PG_EVENT_SVR_KICK_OUT = 21,          // ߳ΪһͬIDĽڵ¼ˡ

	PG_EVENT_LAN_SCAN = 32,              // ɨP2Pڵ㷵¼ԵpgLanScanResult()ȥս
	PG_EVENT_PEER_FWD_STATUS = 33,       // ڵת״̬ϢpgPeerFwdStatus()ȡ
	PG_EVENT_PEER_FWD_STATISTIC = 34,    // ڵתģףͳϢpgPeerFwdStatistic()ȡ
	PG_EVENT_PEER_FWD_STAT_USED = 35,    // ڵתģѣͳϢpgPeerFwdStatUsed()ȡ

} PG_EVENT_E;


/**
 *  ݷ/ȼ
 */
typedef enum tagPG_PRIORITY_E {
	PG_PRIORITY_0,         // ȼ0, ȼȼϲܷ̫ݣΪܻӰP2Pģ鱾ͨš
	PG_PRIORITY_1,         // ȼ1
	PG_PRIORITY_2,         // ȼ2
	PG_PRIORITY_3,         // ȼ3, ȼ
	PG_PRIORITY_BUTT,
} PG_PRIORITY_E;


/**
 *  ͨ
 */
typedef enum tagPG_CNNT_E {
	PG_CNNT_Unknown = 0,            // δ֪ûм⵽

	PG_CNNT_IPV4_Pub = 4,           // IPv4ַ
	PG_CNNT_IPV4_NATConeFull = 5,   // ȫ׶NAT
	PG_CNNT_IPV4_NATConeHost = 6,   // ׶NAT
	PG_CNNT_IPV4_NATConePort = 7,   // ˿׶NAT
	PG_CNNT_IPV4_NATSymmet = 8,     // ԳNAT

	PG_CNNT_IPV4_Private = 12,      // ˽ֱ
	PG_CNNT_IPV4_NATLoop = 13,      // ˽NAT

	PG_CNNT_IPV4_TunnelTCP = 16,    // TCPv4ת
	PG_CNNT_IPV4_TunnelHTTP = 17,   // HTTPv4ת

	PG_CNNT_IPV4_PeerFwd = 24,      // P2Pڵת

	PG_CNNT_IPV6_Pub = 32,          // IPv6ַ
	PG_CNNT_IPV6_Local = 36,        // ˽IPv6ַ

	PG_CNNT_IPV6_TunnelTCP = 40,    // TCPv6ת
	PG_CNNT_IPV6_TunnelHTTP = 41,   // HTTPv6ת

	PG_CNNT_P2P = 128,              // P2P
	PG_CNNT_Local = 129,            // ˽
	PG_CNNT_PeerForward = 130,      // ڵת
	PG_CNNT_RelayForward = 131,     // мת

	PG_CNNT_Offline = 0xffff,       // Զ˲

} PG_CNNT_E;


/**
 *  ڵת״̬
 */
typedef enum tagPG_PEER_FWD_STA_E {
	PG_PEER_FWD_STA_DISABLE = 0,    // ڵתΪá
	PG_PEER_FWD_STA_PAUSE = 1,      // ڵתΪͣΪʹ
	PG_PEER_FWD_STA_IDLE = 2,       // ڵתΪãҵǰС
	PG_PEER_FWD_STA_USED = 3,       // ڵתΪãҵǰЭת
} PG_PEER_FWD_STA_E;


/**
 * ѡķʽ
 */
typedef enum tagPG_NET_MODE_E {
	PG_NET_MODE_Auto,               // Զѡ
	PG_NET_MODE_P2P,                // ֻʹP2P͸
	PG_NET_MODE_Relay,              // ֻʹRelayת
} PG_NET_MODE_E;


/**
 *  ʼ
 */
typedef struct tagPG_INIT_CFG_S {

	// 4ȼķͻȣλΪKֽڡ
	// uBufSize[0] Ϊȼ0ķͻȣ0ʹȱʡֵȱʡֵΪ128(K)
	// uBufSize[1] Ϊȼ1ķͻȣ0ʹȱʡֵȱʡֵΪ128(K)
	// uBufSize[2] Ϊȼ2ķͻȣ0ʹȱʡֵȱʡֵΪ256(K)
	// uBufSize[3] Ϊȼ3ķͻȣ0ʹȱʡֵȱʡֵΪ256(K)
	// ʾڴ治ǳʼʱͷãҪõʱŷ䡣
	//       磬256(K)ǰֻʹ16(K)ֻ16(K)ڴ档
	//       󣬷͵ݲڻ򻺳ʵʹõĳȲ
	// ע⣺ĳֵܳ32768
	unsigned int uBufSize[PG_PRIORITY_BUTT];

	// Ựӵĳʱʱ䡣0ʹȱʡֵȱʡֵΪ30롣
	// ʱڣӲɹϱPG_EVENT_CLOSE¼
	unsigned int uSessTimeout;
									
	// P2P͸ʱ䡣ʱ䵽ûд͸лתͨš
	// (uTryP2PTimeout == 0)ʹȱʡֵȱʡֵΪ6롣
	// (uTryP2PTimeout > 0 && uTryP2PTimeout <= 3600)ʱֵΪuTryP2PTimeout
	// (uTryP2PTimeout > 3600)P2P͸ֱת
	// !! [˲Ѿãο pgSetConfig() '(P2PTryTime){}']
	unsigned int uTryP2PTimeout;

	// P2Pڵڵת0תʣֽ/룩0ת
	// : 32K (ֽ/) ϡ
	// !! [˲Ѿãο pgSetConfig() '(ForwardSpeed){}']
	unsigned int uForwardSpeed;

	// Ƿ3P2Pڵת0ǣ0
	// !! [˲Ѿãο pgSetConfig() '(ForwardUse){}']
	unsigned int uForwardUse;

	// ݳʼĿǰAndroidϵͳJava VMָ롣
	// JNIģʵJNI_OnloadӿڣȡJava VMָ룬pgInitialize()P2Pģ顣
	void* pvParam;
								
} PG_INIT_CFG_S;


/**
 *  ỰϢ
 */
typedef struct tagPG_INFO_S {
	char szPeerID[128];             // ỰԶ˵P2P ID
	char szAddrPub[64];             // ỰԶ˵ĹIPַ
	char szAddrPriv[64];            // ỰԶ˵˽IPַ
	char szListenID[128];           // Ự˵IDڿͻ˵pgInfo()ʱЧ
	unsigned int uCnntType;         // ỰͨͣNATͣö١PG_CNNT_E
} PG_INFO_S;


/**
 * ɨ
 */
typedef struct tagPG_LAN_SCAN_S {
	char szAddr[64];                // ˵ľIPַ
	char szListenID[128];           // ˵ID
} PG_LAN_SCAN_S;


/**
 *  ־ص
 *
 *  uLevel[IN] ־
 *
 *  lpszOut[IN] ־
 */
typedef void (*TfnLogOut)(unsigned int uLevel, const char* lpszOut);


/**
 *  ùò
 *
 *  ʽء
 *
 *  lpszParam [IN] õĲݡ
 *      ַʽĲԲΪΪֵ
 *      ʽʾ(Digest){0}(Debug){0}(DnsRandom){1}(DnsUseIPv4){1}(DnsUseIPv6){1}
 *      
 *      
 *          Digest: ǷժҪ֤ʽ0:ã1:ãĬΪ0
 *          Debug: ǷϢ0:ã1:ãĬΪ0
 *          DnsRandom: ǷѡȡDNSIPַ0:ã1:ãĬΪ1
 *          DnsUseIPv4: ǷʹDNSIPv4ַ0:ã1:ãĬΪ1
 *          DnsUseIPv6: ǷʹDNSIPv6ַ0:ã1:ãĬΪ1
 *          ... οAPI˵ĵ
 *
 *
 *  ֵö١PG_ERROR_EĶ
 */
int pgSetConfig(const char* lpszParam);


/**
 *  P2P͸ģʼ
 *
 *  ʽء
 *
 *  lpuInstID[OUT] ʵIDP2Pģֶ֧ʵʼʱʵID
 *
 *  uMode[IN] ģʽͻ˻ˣö١PG_MODE_E
 *
 *  lpszUser[IN] ͻʱΪʺûʱͨΪ豸ID
 *
 *  lpszPass[IN] ͻʱΪʺ
 *
 *  lpszSvrAddr[IN] P2Pĵַ˿ڣ磺127.0.0.1:3333
 * 
 *  lpszRelayList[IN] м̷ַбP2P޷͸ͨм̷ת
 *      ʽʾ"type=0&load=0&addr=127.0.0.1:443;type=1&load=100&addr=192.168.0.1:8000"
 *      ÿм̷typeloadaddrм̷֮÷ֺš;
 * 
 *  lpstInitCfg[IN] ʼṹPG_INIT_CFG_SĶ塣
 *
 *  pfnLogOut[IN] ־صָ롣صԭͼTfnLogOut塣
 *
 *  ֵö١PG_ERROR_EĶ
 */
int pgInitialize(unsigned int* lpuInstID, unsigned int uMode,
	const char* lpszUser, const char* lpszPass, const char* lpszSvrAddr,
	const char* lpszRelayList, PG_INIT_CFG_S *lpstInitCfg, TfnLogOut pfnLogOut);


/**
 *  P2P͸ģͷԴ
 * 
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 */
void pgCleanup(unsigned int uInstID);


/**
 *  ־ļ
 *
 *  ʽء
 *
 *  uLevel[IN] ־
 *          0Ҫ־ϢĬϿ
 *          1϶൫Ҫ־ϢĬϹرգ
 *
 *  uEnable[IN] 0رգ0
 *
 *  ֵ0ΪɹС0Ϊ
 */
int pgLevel(unsigned int uLevel, unsigned int uEnable);


/**
 *  ȡʵ˵P2P ID
 * 
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  lpszSelfID[OUT] ܱP2P IDĻ
 *
 *  uSize[IN] lpszSelfIDĳȣС128ֽڡ
 *
 *  ֵö١PG_ERROR_EĶ塣
 */
int pgSelf(unsigned int uInstID, char* lpszSelfID, unsigned int uSize);


/**
 *  ȴײ¼ĺͬʱȴỰϵĶ¼¼ء
 *
 *  ʽ¼ﵽȴʱ󷵻ء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  lpuEventNow[OUT] ǰ¼ö١PG_EVENT_E
 *
 *  lpuSessIDNow[OUT] ǰ¼ĻỰID
 *      ڡPG_EVENT_SVR_XXX¼ʱԴ˲
 *
 *  lpuPrio[OUT] ǰ¼ȼö١PG_PRIORITY_E塣
 *      ڡPG_EVENT_SVR_XXX¼ʱԴ˲
 *
 *  uTimeout[IN] ȴʱʱ()0Ϊȴء
 *
 *  ֵö١PG_ERROR_EĶ塣
 */
int pgEvent(unsigned int uInstID, unsigned int* lpuEventNow,
	unsigned int* lpuSessIDNow, unsigned int* lpuPrio, unsigned int uTimeout);


/**
 *  һỰͬʱ˷ֻڿͻģʽã
 *
 *  ʽء
 *      ӲɣpgEvent()յPG_EVENT_CONNECT¼Ӳųɹ
 *      pgEvent()յPG_EVENT_CLOSE¼˵޷ɹҪpgClose()رջỰ
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  lpszListenID[IN] ˵IDҲpgInitialize()дġlpszUserû
 *
 *  lpuSessID[OUT] ỰID
 *
 *  ֵö١PG_ERROR_EĶ塣
 */
int pgOpen(unsigned int uInstID, const char* lpszListenID, unsigned int* lpuSessID);


/**
 *  һỰϷ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  uSessID[IN] ỰID
 *
 *  lpvData[IN] ݻַ
 *
 *  uDataLen[IN] ݳȡ
 *      ΪܣһηͽϳݣP2PģڲὫݽзƬ䣬ڽնٰϻԭ
 *      һη͵ݳȲܳP2PģڲķͻĳȣοPG_INIT_CFG_SṹuBufSizeԵ˵
 *
 *  uPriority[IN] ȼö١PG_PRIORITY_E塣
 *
 *  ֵ0Ϊ͵ݳȡС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgWrite(unsigned int uInstID, unsigned int uSessID,
	const void* lpvData, unsigned int uDataLen, unsigned int uPriority);


/**
 *  һỰϽ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  uSessID[IN] ỰID
 *
 *  lpvBuf[OUT] ջַ
 *
 *  uBufLen[IN] ȡ
 *      pgRead()һνյݵpgWrite()һη͵ݡ
 *      pgWrite()һη͵ݺܳ16KֽڣP2PģԶݷƬд䡣
 *      ڽնˣP2PģѷƬϻԭpgRead()һζpgWrite()һη͵ݡ
 *
 *  lpuPriority[OUT] ȼö١PG_PRIORITY_E塣
 *
 *  ֵ0ΪյݳȡС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgRead(unsigned int uInstID, unsigned int uSessID,
	void* lpvBuf, unsigned int uBufLen, unsigned int* lpuPriority);


/**
 *  ȡ˵ַϢһỰԶ˵ĵַϢ
 *        ҪյPG_EVENT_INFO¼Ժ󣬲ܳɹȡЧϢ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  uSessID[IN] ỰIDuSessIDΪ0ʱȡ˵ϢuSessIDΪ0ʱȡԶ˵Ϣ
 *
 *  lpstInfo[OUT] ȡĻỰϢPG_INFO_Sṹ
 *
 *  ֵ0ΪɹС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgInfo(unsigned int uInstID, unsigned int uSessID, PG_INFO_S* lpstInfo);


/**
 *  ȡһỰķͻʣ֡
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  uSessID[IN] ỰID
 *
 *  uPriority[IN] ȼö١PG_PRIORITY_E塣
 *
 *  ֵڵ0Ϊͻʣ֡С0Ϊ
 */
int pgPend(unsigned int uInstID, unsigned int uSessID, unsigned int uPriority);


/**
 *  鿴ǰҪյݵĳȺȼ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  uSessID[IN] ỰID
 *
 *  lpuPriority [OUT] ǰҪյݵȼö١PG_PRIORITY_E塣
 *
 *  ֵڵ0ΪǰҪյݵĳȣС0Ϊ
 */
int pgPeek(unsigned int uInstID, unsigned int uSessID, unsigned int* lpuPriority);


/**
 *  жһỰǷѾɡ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  uSessID[IN] ỰID
 *
 *  ֵ0ΪѾӡС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgConnected(unsigned int uInstID, unsigned int uSessID);


/**
 *  رһỰ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  uSessID[IN] ỰID
 */
void pgClose(unsigned int uInstID, unsigned int uSessID);


/**
 *  P2Pһ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  lpszData[IN] ͵ݣַ
 *
 *  uParam[IN] ԶĿʹӦܹƥ䣩
 *
 *  ֵ0ΪɹС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgServerRequest(unsigned int uInstID, const char* lpszData, unsigned int uParam);


/**
 *  P2PӦ
 *      pgEvent()յPG_EVENT_SVR_REPLY¼ʱô˺Ӧݡ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  lpszData[OUT] ӦݵĻP2Pصַ
 *
 *  uSize[IN] ջĳ
 *
 *  lpuParam[OUT] pgServerRequest()Զ
 *
 *  ֵڵ0ΪջеӦݳȡС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgServerReply(unsigned int uInstID, char* lpszData, unsigned int uSize, unsigned int* lpuParam);


/**
 *  P2P͡
 *      pgEvent()յPG_EVENT_SVR_NOTIFY¼ʱô˺ݡ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  lpszData[OUT] ݵĻP2P͵ַ
 *
 *  uSize[IN] ջĳ
 *
 *  ֵڵ0ΪջеݳȡС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgServerNotify(unsigned int uInstID, char* lpszData, unsigned int uSize);


/**
 *  ָP2P緽ʽ
 *      ֻϵͳʹP2Pʱֻߣл
 *      ֻʹRelayת(PG_NET_MODE_Relay)ʽӣǿֻAPP״̬µ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  uMode[IN] ӷʽPG_NET_MODE_Eö١
 *
 *  ֵ0ΪɹС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgServerNetMode(unsigned int uInstID, unsigned int uMode);


/**
 *  ڵP2Pڵ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  ֵ0ΪɹС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgLanScanStart(unsigned int uInstID);


/**
 *  ȡP2PڵĽ
 *        ϱPG_EVENT_LAN_SCAN¼֮á
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  lpstLanList[OUT] վP2PڵϢ顣
 *
 *  uSize[IN] ջĳ
 *
 *  ֵڵ0ΪصP2PڵС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgLanScanResult(unsigned int uInstID, PG_LAN_SCAN_S* lpstLanList, unsigned int uSize);


/**
 *  ȡģİ汾
 *
 *  ʽء
 *
 *  lpszVersion[OUT] ܰ汾ϢĻ
 *
 *  uSize[IN] ĳȣڵ16ֽڣ
 */
void pgVersion(char* lpszVersion, unsigned int uSize);


/**
 *  Ե¼P2P
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  uDelay[IN] ʱ룩
 *
 *  ֵ0ΪɹС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgLoginNow(unsigned int uInstID, unsigned int uDelay);


/**
 *  ȡڵת״̬Ϣ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  lpuStatus[OUT] ǰ״̬ö١PG_PEER_FWD_STA_EĶ壩
 *  lpuSessCount[OUT] ǰЭתỰ
 *
 *  ֵ0ΪɹС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgPeerFwdStatus(unsigned int uInstID, unsigned int* lpuStatus, unsigned int* lpuSessCount);


/**
 *  ȡڵתģףͳϢ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  lpuSpeed[OUT] ǰ׵תٶȣֽ/룩
 *  lpuByteCount[OUT] һεô˺Ѿ׵Эתֽ
 *
 *  ֵ0ΪɹС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgPeerFwdStatistic(unsigned int uInstID, unsigned int* lpuSpeed, unsigned int* lpuByteCount);


/**
 *  ȡڵתģѣͳϢ
 *
 *  ʽء
 *
 *  uInstID[IN] ʵIDpgInitialize()ʱ
 *
 *  lpuSendSpeed[OUT] ǰѵķͷתٶȣֽ/룩
 *  lpuSendByteCount[OUT] һεô˺Ѿѵķͷתֽ
 *  lpuRecvSpeed[OUT] ǰѵĽշתٶȣֽ/룩
 *  lpuRecvByteCount[OUT] һεô˺ѾѵĽշתֽ
 *
 *  ֵ0ΪɹС0Ϊ루ö١PG_ERROR_EĶ壩
 */
int pgPeerFwdStatUsed(unsigned int uInstID, unsigned int* lpuSendSpeed,
	unsigned int* lpuSendByteCount, unsigned int* lpuRecvSpeed, unsigned int* lpuRecvByteCount);


#ifdef __cplusplus
}
#endif


#endif // _PG_LIB_CONNECT_H
