// ConnectListen.cpp : ̨Ӧóڵ㡣
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pgLibConnect.h"


void LogOutput(unsigned int uLevel, const char* lpszOut)
{
	printf(lpszOut);
}


int main(int argc, char* argv[])
{
	// Get lib version.
	char szVer[32] = {0};
	pgVersion(szVer, sizeof(szVer));
	printf("pgLibConnect version: %s\n\n", szVer);

	char szDevID[128] = {0};
	char szSvrAddr[128] = {0};

	printf("Input the device id: ");
	gets(szDevID);
	if (szDevID[0] == '\0') {
		strcpy(szDevID, "1111");
	}

	printf("Input the server address: ");
	gets(szSvrAddr);
	if (szSvrAddr[0] == '\0') {
		strcpy(szSvrAddr, "connect.peergine.com:7781");
	}

	pgSetConfig("(ForwardSpeed){1000000}");

	unsigned int uInstID = 0;
	PG_INIT_CFG_S stInitCfg;
	memset(&stInitCfg, 0, sizeof(stInitCfg));

	if (pgInitialize(&uInstID, PG_MODE_LISTEN, szDevID, "",
		szSvrAddr, "", &stInitCfg, LogOutput) != PG_ERROR_OK)
	{
		printf("Init peergine module failed.\n");
		return 0;
	}

	printf("Init peergine module success.\n");

	unsigned int uSessID = 0;
	while (1) {
		unsigned int uEventNow = PG_EVENT_NULL;
		unsigned int uSessIDNow = 0;
		unsigned int uPrio = 0;
		int iErr = pgEvent(uInstID, &uEventNow, &uSessIDNow, &uPrio, 20);
		if (iErr != PG_ERROR_OK) {
			if (iErr != PG_ERROR_TIMEOUT) {
				printf("pgEvent: iErr=%d\n", iErr);
			}

			continue;
		}

		if (uEventNow == PG_EVENT_CONNECT) {
			printf("CONNECT: SessID=%u\n", uSessIDNow);

			// Call to pgConnected function
			iErr = pgConnected(uInstID, uSessIDNow);
			if (iErr < 0) {
				printf("pgConnected: iErr=%d\n", iErr);
			}

			uSessID = uSessIDNow;
		}
		else if (uEventNow == PG_EVENT_INFO) {
			printf("INFO: SessID=%u\n", uSessIDNow);

			// Call to pgInfo function
			PG_INFO_S stInfo;
			int iRet = pgInfo(uInstID, uSessIDNow, &stInfo);
			if (iRet == PG_ERROR_OK) {
				printf("pgInfo: PeerID=%s, AddrPub=%s, AddrPriv=%s, ListenID=%s, CnntType=%u\n",
					stInfo.szPeerID, stInfo.szAddrPub, stInfo.szAddrPriv, stInfo.szListenID, stInfo.uCnntType);
			}
		}
		else if (uEventNow == PG_EVENT_CLOSE) {
			printf("CLOSE: SessID=%u\n", uSessIDNow);
			pgClose(uInstID, uSessIDNow);
			if (uSessIDNow == uSessID) {
				uSessID = 0;
			}
		}
		else if (uEventNow == PG_EVENT_READ) {
			printf("READ: SessID=%u, uPrio=%u\n", uSessIDNow, uPrio);

			// Call to pgPeek function
			unsigned int uPrio1 = 0;
			int iRetPeek = pgPeek(uInstID, uSessIDNow, &uPrio1);
			if (iRetPeek < PG_ERROR_OK) {
				printf("pgRead: iErr=%d\n", iRetPeek);
				continue;
			}

			printf("pgPeek: DataSize=%d, uPrio=%u\n", iRetPeek, uPrio1);

			// Call to pgRead function
			char szBuf[2048] = {0};
			unsigned int uPrio2 = 0;
			int iRet = pgRead(uInstID, uSessIDNow, szBuf, (sizeof(szBuf) - 1), &uPrio2);
			if (iRet < PG_ERROR_OK) {
				printf("pgRead: iErr=%d\n", iRet);
				continue;
			}

			szBuf[iRet] = '\0';
			printf("COMMAND: %s\n", szBuf);

			// Call to pgWrite function
			strcpy(szBuf, "Done");
			iRet = pgWrite(uInstID, uSessIDNow, szBuf, strlen(szBuf), uPrio2);
			if (iRet < PG_ERROR_OK) {
				printf("pgWrite: iErr=%d\n", iRet);
			}
		}
		else if (uEventNow == PG_EVENT_WRITE) {
			printf("WRITE: SessID=%u, uPrio=%u\n", uSessIDNow, uPrio);
		}
		else if (uEventNow == PG_EVENT_SVR_LOGIN) {
			printf("SVR_LOGIN:\n");

			// Call to pgServerRequest function
			int iRet = pgServerRequest(uInstID, "Report: test", 0);
			if (iRet != PG_ERROR_OK) {
				printf("pgServerRequest: iErr=%d\n", iRet);
			}
		}
		else if (uEventNow == PG_EVENT_SVR_LOGOUT) {
			printf("SVR_LOGOUT:\n");
		}
		else if (uEventNow == PG_EVENT_SVR_REPLY) {
			printf("SVR_REPLY:\n");

			// Call to pgServerReply function
			char szBuf[2048] = {0};
			unsigned int uParam = 0;
			int iRet = pgServerReply(uInstID, szBuf, sizeof(szBuf), &uParam);
			if (iRet < PG_ERROR_OK) {
				printf("pgServerReply: iErr=%d\n", iRet);
				continue;
			}

			szBuf[iRet] = '\0';
			printf("Reply: %s\n", szBuf);
		}
		else if (uEventNow == PG_EVENT_SVR_NOTIFY) {
			printf("SVR_NOTIFY:\n");

			// Call to pgServerNotify function
			char szBuf[2048] = {0};
			unsigned int uParam = 0;
			int iRet = pgServerNotify(uInstID, szBuf, sizeof(szBuf));
			if (iRet < PG_ERROR_OK) {
				printf("pgServerNotify: iErr=%d\n", iRet);
				continue;
			}

			szBuf[iRet] = '\0';
			printf("Notify: %s\n", szBuf);
		}
		else if (uEventNow == PG_EVENT_SVR_KICK_OUT) {
			printf("SVR_KICK_OUT:\n");
		}
	}

	pgCleanup(uInstID);
	printf("Clean peergine module.");

	getchar();
	return 0;
}
