
package com.example.democonnect;

import java.lang.*;
import java.util.Scanner;
import com.peergine.connect.pgJniConnect;


public class demoJniConnect {

	static Scanner in = new Scanner(System.in);

	public static void main(String[] args) {
		
		System.out.print("Input listen device id: ");
		String sDevID = in.next();

		pgJniConnect.jniSetConfig("(ForwardSpeed){1000000}");

		int iInstID = pgJniConnect.jniInitialize(pgJniConnect.PG_MODE_CLIENT,
			"testJni", "", "connect.peergine.com:7781", "", "", 0, 0, 0, 0, 30, 0, 0, 0);
		if (iInstID < pgJniConnect.PG_ERROR_OK) {
			System.out.println("jniInitialize: iErr=" + iInstID);
			return;
		}
		
		int iSessID = 0;
		boolean bLanScan = false;
		
		while (true) {
			if (iSessID == 0) {
				iSessID = pgJniConnect.jniOpen(iInstID, sDevID);
				if (iSessID < pgJniConnect.PG_ERROR_OK) {
					System.out.println("jniOpen: iErr=" + iSessID);
					return;
				}
			}
			
			pgJniConnect.OutEvent evOut = new pgJniConnect.OutEvent();
			int iErr = pgJniConnect.jniEvent(iInstID, 10000, evOut);
			if (iErr < pgJniConnect.PG_ERROR_OK) {
				if (iErr != pgJniConnect.PG_ERROR_TIMEOUT) {
					System.out.println("jniEvent: iErr=" + iErr);
					break;
				}

				// Send "Hello Peergine" to Listen side.
				try {
					byte[] byData = "Hello Peergine".getBytes("UTF8");
					iErr = pgJniConnect.jniWrite(iInstID, iSessID, byData, 1);
					if (iErr < pgJniConnect.PG_ERROR_OK) {
						System.out.println("jniWrite: iErr=" + iErr);
					}
				}
				catch (Exception ex) {
				}

				// Scan the listen side in the same LAN.
				if (!bLanScan) {
					iErr = pgJniConnect.jniLanScanStart(iInstID);
					if (iErr >= pgJniConnect.PG_ERROR_OK) {
						bLanScan = true;
					}
				}

				continue;
			}
			
			switch (evOut.iEventNow) {
			case pgJniConnect.PG_EVENT_CONNECT:
				System.out.println("PG_EVENT_CONNECT: iSessNow=" + evOut.iSessNow);
			
				iErr = pgJniConnect.jniConnected(iInstID, evOut.iSessNow);

				break;

			case pgJniConnect.PG_EVENT_CLOSE:
				System.out.println("PG_EVENT_CLOSE: iSessNow=" + evOut.iSessNow);
				pgJniConnect.jniClose(iInstID, evOut.iSessNow);
				if (evOut.iSessNow == iSessID) {
					iSessID = 0;
				}
				break;

			case pgJniConnect.PG_EVENT_WRITE:
				System.out.println("PG_EVENT_WRITE: iSessNow=" + evOut.iSessNow);

				iErr = pgJniConnect.jniPend(iInstID, evOut.iSessNow, 1);

				break;

			case pgJniConnect.PG_EVENT_READ:
				System.out.println("PG_EVENT_READ: iSessNow=" + evOut.iSessNow);

				// Read the data.
				pgJniConnect.OutRead outRead = new pgJniConnect.OutRead();
				int iRet = pgJniConnect.jniRead(iInstID, evOut.iSessNow, 4096, outRead);
				if (iRet < pgJniConnect.PG_ERROR_OK) {
					System.out.println("jniRead: iErr=" + iRet);
				}
				else {
					try {
						String sOut = new String(outRead.byBuf, "UTF-8");
						System.out.println("jniRead: Data=" + sOut);
					}
					catch (Exception ex) {
					}
				}
				break;

			case pgJniConnect.PG_EVENT_OFFLINE:
				System.out.println("PG_EVENT_OFFLINE: iSessNow=" + evOut.iSessNow);
				break;

			case pgJniConnect.PG_EVENT_INFO:
				System.out.println("PG_EVENT_INFO: iSessNow=" + evOut.iSessNow);
				
				pgJniConnect.OutInfo outInfo = new pgJniConnect.OutInfo();
				iRet = pgJniConnect.jniInfo(iInstID, evOut.iSessNow, outInfo);
				if (iRet < pgJniConnect.PG_ERROR_OK) {
					System.out.println("jniInfo: iErr=" + iRet);
				}
				else {
					System.out.println("jniInfo: sPeerID=" + outInfo.sPeerID + ", sAddrPub="
						+ outInfo.sAddrPub + ", sAddrPriv=" + outInfo.sAddrPriv + ", sListenID="
						+ outInfo.sListenID + ", iCnntType=" + outInfo.iCnntType);
				}
				break;

			case pgJniConnect.PG_EVENT_SVR_LOGIN:
				System.out.println("PG_EVENT_SVR_LOGIN: ");

				iRet = pgJniConnect.jniServerRequest(iInstID, "Hello Server", 0);
				if (iRet < pgJniConnect.PG_ERROR_OK) {
					System.out.println("jniServerRequest: iErr=" + iRet);
				}
				break;

			case pgJniConnect.PG_EVENT_SVR_LOGOUT:
				System.out.println("PG_EVENT_SVR_LOGOUT: ");
				break;

			case pgJniConnect.PG_EVENT_SVR_REPLY:
				System.out.println("PG_EVENT_SVR_REPLY: ");

				pgJniConnect.OutSvrReply outSvrReply = new pgJniConnect.OutSvrReply();
				iRet = pgJniConnect.jniServerReply(iInstID, outSvrReply);
				if (iRet < pgJniConnect.PG_ERROR_OK) {
					System.out.println("jniServerReply: iErr=" + iRet);
				}
				else {
					System.out.println("jniServerReply: Data=" + outSvrReply.sData);
				}
				break;

			case pgJniConnect.PG_EVENT_SVR_NOTIFY:
				System.out.println("PG_EVENT_SVR_NOTIFY: ");

				pgJniConnect.OutSvrNotify outSvrNotify = new pgJniConnect.OutSvrNotify();
				iRet = pgJniConnect.jniServerNotify(iInstID, outSvrNotify);
				if (iRet < pgJniConnect.PG_ERROR_OK) {
					System.out.println("jniServerNotify: iErr=" + iRet);
				}
				else {
					System.out.println("jniServerNotify: Data=" + outSvrNotify.sData);
				}
				break;

			case pgJniConnect.PG_EVENT_LAN_SCAN:
				System.out.println("PG_EVENT_LAN_SCAN: ");
				
				pgJniConnect.OutLanScanResult outLanScanResult = new pgJniConnect.OutLanScanResult();
				iRet = pgJniConnect.jniLanScanResult(iInstID, outLanScanResult);
				if (iRet < pgJniConnect.PG_ERROR_OK) {
					System.out.println("jniLanScanResult: iErr=" + iRet);
				}
				else {
					for (int i = 0; i < outLanScanResult.Result.length; i++) {
						System.out.println("jniLanScanResult[" + i + "]: sID=" + outLanScanResult.Result[i].sID
							+ ", sAddr=" + outLanScanResult.Result[i].sAddr);
					}
				}
				break;

			case pgJniConnect.PG_EVENT_PEER_FWD_STATUS:
				System.out.println("PG_EVENT_PEER_FWD_STATUS: ");

				pgJniConnect.OutPeerFwdStatus outPeerFwdStatus = new pgJniConnect.OutPeerFwdStatus();
				iRet = pgJniConnect.jniPeerFwdStatus(iInstID, outPeerFwdStatus);
				if (iRet < pgJniConnect.PG_ERROR_OK) {
					System.out.println("jniPeerFwdStatus: iErr=" + iRet);
				}
				else {
					System.out.println("jniPeerFwdStatus: iStatus=" + outPeerFwdStatus.iStatus
						+ ", iSessCount=" + outPeerFwdStatus.iSessCount);
				}
				break;

			case pgJniConnect.PG_EVENT_PEER_FWD_STATISTIC:
				System.out.println("PG_EVENT_PEER_FWD_STATISTIC: ");

				pgJniConnect.OutPeerFwdStatistic outPeerFwdStat = new pgJniConnect.OutPeerFwdStatistic();
				iRet = pgJniConnect.jniPeerFwdStatistic(iInstID, outPeerFwdStat);
				if (iRet < pgJniConnect.PG_ERROR_OK) {
					System.out.println("jniPeerFwdStatistic: iErr=" + iRet);
				}
				else {
					System.out.println("jniPeerFwdStatistic: iSpeed=" + outPeerFwdStat.iSpeed
						+ ", iByteCount=" + outPeerFwdStat.iByteCount);
				}
				break;

			case pgJniConnect.PG_EVENT_PEER_FWD_STAT_USED:
				System.out.println("PG_EVENT_PEER_FWD_STAT_USED: ");

				pgJniConnect.OutPeerFwdStatUsed outPeerFwdStatUsed = new pgJniConnect.OutPeerFwdStatUsed();
				iRet = pgJniConnect.jniPeerFwdStatUsed(iInstID, outPeerFwdStatUsed);
				if (iRet < pgJniConnect.PG_ERROR_OK) {
					System.out.println("jniPeerFwdStatUsed: iErr=" + iRet);
				}
				else {
					System.out.println("jniPeerFwdStatUsed: iSendSpeed=" + outPeerFwdStatUsed.iSendSpeed
						+ ", iSendByteCount=" + outPeerFwdStatUsed.iSendByteCount
						+ ", iRecvSpeed=" + outPeerFwdStatUsed.iRecvSpeed
						+ ", iRecvByteCount=" + outPeerFwdStatUsed.iRecvByteCount);
				}
				break;
			}
		}

		pgJniConnect.jniCleanup(iInstID);
		System.out.println("jniCleanup");	
	}
}
