(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.Render = f()}})(function(){var define,module,exports;return (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
require('./pgLibError');
var START_CALL_REQUEST = 0;
var START_CALL_RESPONES = 1;

//-----------------------------------------------------------------
// Error codes.

String.prototype.equals = function (obj){
    return this == obj;
};

if (typeof pgCallFlowError == "undefined") {
    var pgCallFlowError = {
        OK: 0,
        NoInit: 1,
        RunTime: 2,
        BadStatus: 3,
        SendFailed: 4,
        BadParam: 5,
        Offline: 6,
        Timeout: 7,
        Network: 8
    };
}

function ExtVideoObjParseID ( sObj){
    var sPeer = sObj.indexOf("EXT_VIDEO_") == 0 ? sObj.substring(10) : "";

    var Ind = sPeer.lastIndexOf("_");
    if(Ind > 0){
        return sPeer.substring(0,Ind);
    }else{
        return sPeer;
    }
}

function ObjPeerParseID(sObj){

    var sPeer =  (sObj.indexOf("_RND_") == 0 || sObj.indexOf("_CAP_") == 0) ? sObj.substring(5) : "";

    var Ind = sPeer.lastIndexOf("_");
    if(Ind > 0){
        return sPeer.substring(0,Ind);
    }else{
        return sPeer;
    }
}

var context = null;
function showToast(context, msg) {
    if(typeof debugOutString == "function" ){
        debugOutString(msg);
    }else{
        console.log(msg);
    }
    
}

function showAlert(context, sTitle, sMsg) {
    alert(sTitle + ": " + sMsg)
}

function isEmpty(s) {
    if (null == s || typeof s != "string")
        return true;
    if (s.length == 0)
        return true;
    return false;
}

function showText(sOut) {
    var sData = "Render: " + sOut;
    if(typeof debugOutString == "function" ){
        debugOutString(sData);
    }else{
        console.log(sData);
    }
}

function Alert(sTitle, sMsg) {
    alert(sTitle + ":" + sMsg);
}


/**
 * @author ctkj
 * @date 2017/8/29
 */

function Render(live, extvideo, callflow,contactManage) {

    var m_Live = this.m_Live = live;
    var extVideo = this.extVideo = extvideo;
    var m_contactManage = this.contactManage = contactManage;
    var m_callFlow = this.m_callFlow = callflow;
    this.m_bInited = false;
    this.m_bLogin = false;

    this.prvwSurfaceView = "";
    this.otherSurfaceView = "";

    this.mExtVideoPrvw = "";
    this.captureSurfaceView = "";


    this.sCapID = "";

    this.GetLive = function () {
        return m_Live;
    };

    this.Init = function (Node,sSvrAddr, sSelfID,sPass, sRelayAddr , iTryTime ,prvwSurfaceView,captureSurfaceView,otherSurfaceView) {

        var iErr = m_callFlow.Initialize(sSelfID, "", 0, 0);
        if (iErr != 0) {
            showAlert("Error", "LiveStart: init call flow failed!");
            return iErr;
        }


        m_Live.SetNodeEventHook(extVideo.getHook());
    
        iErr = m_Live.Initialize(sSelfID,
            sPass, sSvrAddr, sRelayAddr, iTryTime, "(Debug){1}(LogLevel2){1}(LogLevel3){1}");
        if (iErr != PG_ERR_Normal) {
            console.log("pgLiveRander", "LiveStart: Live.Initialize failed!");
            m_callFlow.Cleanup();
            return iErr;
        }

        //旋转了采集方向(Portrait){1}
        extVideo.setOnEvent(this);
        var sExtVideoParam = "(Code){3}(Mode){10}(Rate){66}(BitRate){800}";
        iErr = extVideo.initialize(Node, m_Live.GetSelfPeer(), sExtVideoParam, "");
        if (iErr != PG_ERR_Normal) {
            console.log("pgLiveRander" + "LiveStart: Live.Initialize failed!");
            m_Live.Clean();
            m_callFlow.Cleanup();
            return iErr;
        }
        this.captureSurfaceView = captureSurfaceView; //pgLibLiveMultiView.Get("v0");
        this.prvwSurfaceView = prvwSurfaceView; //extVideo.getPrewview(320, 240);
        this.otherSurfaceView = otherSurfaceView; //pgLibView.Get("v1");
        extVideo.setPrewview(prvwSurfaceView);

        return iErr;
    };

    this.Clean = function () {
        
        if (extVideo != null) {
            extVideo.clean();
        }

        if (m_Live != null) {
            m_Live.Clean();
        }

        m_callFlow.Cleanup();
        this.m_bLogin = false;
        this.m_bInited = false;
    };

    this.CallRequest = function (sID, sInfo) {
        if (!this.m_bLogin) {
            showToast(null, "还没有登录，请登录后再试");
            return PG_ERR_BadStatus;
        }
        return m_callFlow.Request(sID, sInfo);
    };

    this.CallCancel = function (sID, sInfo) {
        return m_callFlow.Cancel(sInfo);
    };
    this.CallAccpet = function (sID, sInfo) {
        
        contactManage.ContactAdd(sID, sID);
        this.sCapID = sID;
        var iErr = this.startPlay(sID);
        if (iErr > 0) {
            this.sCapID = "";
            return iErr;
        }

        iErr = m_callFlow.Accept(sInfo);
        if (iErr > 0) {
            this.sCapID = "";
            this.stopPlay(sID);
            return iErr;
        }
        iErr = this.reqGetObjPeer(sID,"");
        if(iErr > 0){
            showAlert(context,"错误","启动视频失败。 iErr = " + iErr);
            this.stopPlay(sID);
        }
        return iErr;
    };

    this.CallReject = function (sID, sInfo) {

        return m_callFlow.Reject(sInfo);
    };

    this.CallTerminate = function (sID, sInfo) {
        m_callFlow.Terminate(sInfo);
        this.stopPlay(sID);
    };

    this.startPlay = function (sID) {
        var iErr = this.startPlayLive(sID);
        // this.reqGetObjPeer(sID,"");
        return iErr;
    };

    this.stopPlay = function (sID) {
        this.extStop();
        this.stopPlayLive(sID);
    };

    this.startPlayLive = function (sID) {
        if (m_Live == null) {
            return PG_ERR_System;
        }
        var iErr = m_Live.Connect(sID);
        if (iErr > 0) {
            return iErr;
        }
        iErr = m_Live.VideoStart(sID, 0, "", this.captureSurfaceView);
        if (iErr > 0) {
            m_Live.Disconnect(sID);
            return iErr;
        }

        iErr = m_Live.AudioStart(sID, 0, "");
        if (iErr > 0) {
            m_Live.VideoStop(sID, 0);
            m_Live.Disconnect(sID);
            return iErr;
        }
        return iErr;
    };

    this.stopPlayLive = function (sID) {
        if (m_Live == null) {
            return;
        }

        m_Live.AudioStop(sID, 0);
        m_Live.VideoStop(sID, 0);
        m_Live.Disconnect(sID);
    };

    this.OnError = function (sPeer, iErr) {
        //  EventBus.getDefault().post(new MessageEvent("OnError", "",sPeer,iErr));
    };

    /**
     * 请求播放端视频流程 - 请求节点完整名称
     * @param sPeer 节点ID
     * @param sParam 参数
     * @return 返回错误码
     */
    this.reqGetObjPeer = function (sPeer, sParam) {
        if (extVideo == null) {
            return PG_ERR_BadStatus;
        }
        return extVideo.sendGetObjPeer(sPeer, sParam);
    };

    /**
     * 请求播放端视频流程-同意应答
     * @param sObjPeer 节点完整名称 前缀+ID+（后缀）
     * @param sParam 参数
     * @return 返回错误码
     */
    this.resGetObjPeer = function (sObjPeer, sParam) {
        this.extStart(sObjPeer);

        var iErr = extVideo.sendGetObjPeerNotify(sObjPeer, sParam);
        if (iErr > pgLibError.PG_ERR_Normal) {
            showToast(null, "回复ID对象消息发送失败" + iErr);
            this.extStop();
            return iErr;
        }

        return pgLibError.PG_ERR_Normal;
    };

    /**
     * 获得完整名称后初启动Ext视频模块
     * @param sObjPeer 节点完整名称
     * @param sParam 参数
     * @return 错误码
     */
    this.resGetObjPeerNotify = function (sObjPeer, sParam) {
        this.extStart(sObjPeer);
        if(this.extReqVideoStartStatus == 2){
            this.extReqVideoStart(this.m_Live.GetSelfPeer());
        }
        return pgLibError.PG_ERR_Normal;
    };

    this.msObjPeer = "";
    this.msVideoPeer = "";

    /**
     * 添加视频通道
     * @param sObjPeer 节点完整名称
     * @return 错误码
     */
    this.extStart = function (sObjPeer) {
        this.extStop();

        var iErr = extVideo.start(sObjPeer);
        if (iErr > pgLibError.PG_ERR_Normal) {
            showToast(null, "添加通道失败，错误：" + iErr);
            return iErr;
        }
        this.msObjPeer = sObjPeer;
        return iErr;
    };

    /**
     * 删除通道
     */
    this.extStop = function () {
        this.extVideoStop();
        if (!isEmpty(this.msObjPeer)) {
            extVideo.stop(this.msObjPeer);
            this.msObjPeer = "";
        }
    };

    /**
     * 0 : No request
     * 1 : request ed
     * 2 : request failed
     */
    this.extReqVideoStartStatus = 0;
    this.extReqVideoStart = function (sObjPeer) {
        this.msVideoPeer = sObjPeer;
        var iErr = extVideo.videoStart(sObjPeer, this.otherSurfaceView, true);
        if(iErr > 0 && iErr != PG_ERR_Opened){
            this.extReqVideoStartStatus = 2;
        }
        else{
            this.extReqVideoStartStatus = 1;
        }
    };

    this.extVideoStop = function () {
        if (!isEmpty(this.msVideoPeer)) {
            extVideo.videoStop(this.msVideoPeer, true);
            this.msVideoPeer = "";
        }
    };

    this.onGetObjPeer = function (sObjPeer, sParam) {
        this.resGetObjPeer(sObjPeer, sParam);
    };

    this.onGetObjPeerReply = function (uErr, sParam) {
        if (uErr > 0) {
            var sInfo = "发送请求节点名称失败 : uErr = " + uErr;
            showToast(sInfo);
        }

    };

    this.onGetObjPeerNotify = function (sObjPeer, sParam) {
        var sInfo = "onGetObjPeerNotify : sObjPeer = " + sObjPeer + " sParam = " + sParam;
        
        console.log("ExtVideoEvent " + sInfo);
        this.resGetObjPeerNotify(sObjPeer, sParam);
    };

    this.onVideoSync = function (sObj, sAct, sObjPeer) {
        if ("0".equals(sAct)) {
            //msObjPeer = "";
            //extVideo.stop();
        } else if ("1".equals(sAct)) {
            // var sCaptureID = sObj.substring(10);
            // //
            // if (this.sCapID.equals(sCaptureID)) {
            //     var iErr = this.extReqVideoStart(m_Live.GetSelfPeer());
            //     if (iErr > PG_ERR_Normal) {
            //         showToast(null, "请求视频错误：" + iErr);
            //     }
            //     showToast(null, "正在请求打开视频");
            // }

            var sSelfObjPeer = m_Live.GetSelfPeer();
            var sID1 = ObjPeerParseID(sSelfObjPeer);
            var sID2 = ExtVideoObjParseID(sObj);

            var sID3 = ObjPeerParseID(sObjPeer);
            //
            if(this.sCapID.equals(sID3) && sID1.equals(sID2) ) {
                console.log("ExtVideoEvent onVideoSync : extReqVideoStart");

                var iErr = this.extReqVideoStart(sSelfObjPeer);
                if(iErr > PG_ERR_Normal){
                    showToast(context,"请求视频错误：" + iErr);
                }else{
                    showToast(context,"正在请求打开视频");
                }
               
            }
        }
        //            String sInfo = "onVideoSync : sObj = " + sObj + " sAct = " + sAct + " sObjPeer = " + sObjPeer;
        //            showToast(sInfo);
        return 0;
    };

    this.onVideoStart = function (sObj, uHandle, sPeer) {
        //            String sInfo = "onVideoStart : sObj = " + sObj + " uHandle = " + uHandle + " sPeer = " + sPeer;
        //            showToast(sInfo);
        return -1;
    };

    this.onVideoStartReply = function (sObj, uErr) {
        //            String sInfo = "onVideoStartReply : sObj = " + sObj + " uErr = " + uErr;
        //            showToast(sInfo);
        if (uErr > pgLibError.PG_ERR_Normal) {
            showText("视频打开失败 uErr = " + uErr);
        } else {
            showText("视频打开成功！");
            
            //otherSurfaceView.setZOrderOnTop(true);
        }
        return 0;
    };

    this.onVideoStop = function (sObj, sObjPeer) {
        //            String sInfo = "onVideoStop: " + sObjPeer;
        //            showToast(sInfo);
        return 0;
    };

    this.onVideoFrameStat = function (sObj, sData) {
        showToast("onVideoFrameStat sObj = " + sObj + " sInfo = " + sData);
    };

    this.onAudioSync = function (sObj, sAct) {
        //            String sInfo = "onVideoStop: sObj = " + sObj + " sAct = " + sAct;
        //            showToast(sInfo);
        return 0;
    };

    this.onAudioStart = function (sObj, sPeer) {
        //
        //            String sInfo = "onVideoStop: sObj = " + sObj + " sAct = " + sPeer ;
        //            showToast(sInfo);
        return 0;
    };

    this.onAudioStartRelay = function (sObj, uErr) {
        //
        //            String sInfo = "onVideoStop: sObj = " + sObj + " uErr = " + uErr;
        //            showToast(sInfo);
        return 0;
    };

    this.onAudioStop = function (sPeer) {

        //            String sInfo = "onVideoStop: sPeer = " + sPeer;
        //            showToast(sInfo);
        return 0;
    };


    this.CallFlowMessageReceive = function (sData) {
        var Node = m_Live.GetNode();
        if (Node != null) {
            var sRenID = Node.omlGetContent(sData, "User");
            var sMsg = Node.omlGetContent(sData, "Msg");
            m_callFlow.MessageProc(sRenID, sMsg);
        }
    };

    this.CallFlowMessageReceiveError = function (sData, sRndID) {
        if (sRndID.equals("__callflow")) {
            this.CallFlowMessageError(sData);
        }
    };

    this.CallFlowMessageError = function (sData) {
        var iErrCode = 0;
        try {
            if (!sData.equals("")) {
                iErrCode = parseInt(sData);
            }
        } catch (ex) {
            iErrCode = 0;
        }

        var iMsgErr = 0;
        switch (iErrCode) {
            case PG_ERR_BadObject:
                iMsgErr = pgCallFlowError.Offline;
                break;

            case PG_ERR_BadParam:
                iMsgErr = pgCallFlowError.BadParam;
                break;

            case PG_ERR_Timeout:
                iMsgErr = pgCallFlowError.Timeout;
                break;

            case PG_ERR_Network:
                iMsgErr = pgCallFlowError.ERROR_Network;
                break;
        }

        m_callFlow.MessageError(iMsgErr);
    };

    this.onMessageSend = function (sCallID, sData) {
        var sDataReq = "Forward?(User){" + sCallID + "}(Msg){" + sData + "}";
        var iErr = m_Live.SvrRequest(sDataReq, "__callflow");
        return (iErr < 0 || iErr == PG_ERR_Normal);
    };


}

module.exports = Render;
},{"./pgLibError":2}],2:[function(require,module,exports){
(function (global){

var PG_ERR_Normal = 0;
var PG_ERR_System = 1;
var PG_ERR_BadParam = 2;
var PG_ERR_BadClass = 3;
var PG_ERR_BadMethod = 4;
var PG_ERR_BadObject = 5;
var PG_ERR_BadStatus = 6;
var PG_ERR_BadFile = 7;
var PG_ERR_BadUser = 8;
var PG_ERR_BadPass = 9;
var PG_ERR_NoLogin = 10;
var PG_ERR_Network = 11;
var PG_ERR_Timeout = 12;
var PG_ERR_Reject = 13;
var PG_ERR_Busy = 14;
var PG_ERR_Opened = 15;
var PG_ERR_Closed = 16;
var PG_ERR_Exist = 17;
var PG_ERR_NoExist = 18;
var PG_ERR_NoSpace = 19;
var PG_ERR_BadType = 20;
var PG_ERR_CheckErr = 21;
var PG_ERR_BadServer = 22;
var PG_ERR_BadDomain = 23;
var PG_ERR_NoData = 24;
var PG_ERR_Unknown = 0xff;

var pgLibError = {};

global.PG_ERR_Normal = pgLibError.PG_ERR_Normal = PG_ERR_Normal;
global.PG_ERR_System = pgLibError.PG_ERR_System = PG_ERR_System;
global.PG_ERR_BadParam = pgLibError.PG_ERR_BadParam = PG_ERR_BadParam;
global.PG_ERR_BadClass = pgLibError.PG_ERR_BadClass = PG_ERR_BadClass;
global.PG_ERR_BadMethod = pgLibError.PG_ERR_BadMethod = PG_ERR_BadMethod;
global.PG_ERR_BadObject = pgLibError.PG_ERR_BadObject = PG_ERR_BadObject;
global.PG_ERR_BadStatus = pgLibError.PG_ERR_BadStatus = PG_ERR_BadStatus;
global.PG_ERR_BadFile = pgLibError.PG_ERR_BadFile = PG_ERR_BadFile;
global.PG_ERR_BadUser = pgLibError.PG_ERR_BadUser = PG_ERR_BadUser;
global.PG_ERR_BadPass = pgLibError.PG_ERR_BadPass = PG_ERR_BadPass;
global.PG_ERR_NoLogin = pgLibError.PG_ERR_NoLogin = PG_ERR_NoLogin;
global.PG_ERR_Network = pgLibError.PG_ERR_Network = PG_ERR_Network;
global.PG_ERR_Timeout = pgLibError.PG_ERR_Timeout = PG_ERR_Timeout;
global.PG_ERR_Reject = pgLibError.PG_ERR_Reject = PG_ERR_Reject;
global.PG_ERR_Busy = pgLibError.PG_ERR_Busy = PG_ERR_Busy;
global.PG_ERR_Opened = pgLibError.PG_ERR_Opened = PG_ERR_Opened;
global.PG_ERR_Closed = pgLibError.PG_ERR_Closed = PG_ERR_Closed;
global.PG_ERR_Exist = pgLibError.PG_ERR_Exist = PG_ERR_Exist;
global.PG_ERR_NoExist = pgLibError.PG_ERR_NoExist = PG_ERR_NoExist;
global.PG_ERR_NoSpace = pgLibError.PG_ERR_NoSpace = PG_ERR_NoSpace;
global.PG_ERR_BadType = pgLibError.PG_ERR_BadType = PG_ERR_BadType;
global.PG_ERR_CheckErr = pgLibError.PG_ERR_CheckErr = PG_ERR_CheckErr;
global.PG_ERR_BadServer = pgLibError.PG_ERR_BadServer = PG_ERR_BadServer;
global.PG_ERR_BadDomain = pgLibError.PG_ERR_BadDomain = PG_ERR_BadDomain;
global.PG_ERR_NoData = pgLibError.PG_ERR_NoData = PG_ERR_NoData;
global.PG_ERR_Unknown = pgLibError.PG_ERR_Unknown = PG_ERR_Unknown;

global.pgLibError=pgLibError;

var strErrors = [
    "PG_ERR_Normal",
    "PG_ERR_System",
    "PG_ERR_BadParam",
    "PG_ERR_BadClass",
    "PG_ERR_BadMethod",
    "PG_ERR_BadObject",
    "PG_ERR_BadStatus",
    "PG_ERR_BadFile",
    "PG_ERR_BadUser",
    "PG_ERR_BadPass",
    "PG_ERR_NoLogin",
    "PG_ERR_Network",
    "PG_ERR_Timeout",
    "PG_ERR_Reject",
    "PG_ERR_Busy",
    "PG_ERR_Opened",
    "PG_ERR_Closed",
    "PG_ERR_Exist",
    "PG_ERR_NoExist",
    "PG_ERR_NoSpace",
    "PG_ERR_BadType",
    "PG_ERR_CheckErr",
    "PG_ERR_BadServer",
    "PG_ERR_BadDomain",
    "PG_ERR_NoData"
];

function pgLibErr2Str(iErr){
    if(iErr<0 || iErr >= strErrors.length){
        return "PG_ERR_Unknown";
    }
    return strErrors[iErr];
}



global.pgLibError=pgLibError;
global.pgLibErr2Str=pgLibErr2Str;

/**
 * 判断字符串是否为空
 * @param s 字符串
 * @return true 为空 ，false 不为空
 */
function _isEmpty(s){
    return s == null || ""==(s) || typeof s != "string";
}
global._isEmpty = _isEmpty;
}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})

},{}]},{},[1])(1)
});

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
