
var ContactDatabase = require('./ContactDatabase');
function isEmpty(s){
    if(s == null || typeof s != "string" || s == ""){
        return true;
    }
    return false;
}

function ContactManage(oContactListView){
    
    this.contactDatabase = null;
    this.m_contactList = [];
    this.ContactInit = function(name){
        this.contactDatabase = new ContactDatabase(name);
        
        this.flashContactList();
        return 0;
    };
    this.ContactClean = function(){
        if(this.contactDatabase!=null){
            
            this.contactDatabase =null;
        }
    };

    this.flashContactList = function(){
        if(this.contactDatabase!=null){
            this.m_contactList = [];
            this.m_contactList = this.contactDatabase.readContacts();
            this.notifyDataSetChanged();
        }
    };

    this.ContactAdd = function(sID,displayName){
        if(this._Search(sID)){
            return;
        }
        if(this.contactDatabase!=null){
            this.contactDatabase.insertContact(displayName,sID);
            this.flashContactList();
        }
    };

    this.ContactRemove = function(sID){
        if(this.contactDatabase!=null){
            this.contactDatabase.removeContact(sID);
            this.flashContactList();
        }
    };
    this.ContactRemoveList = function(arr){
        if(this.contactDatabase!=null){
            this.contactDatabase.removeContactList(arr);
            this.flashContactList();
        }
    };

    this.ContactUpdata = function(sID,displayName){
        if(this.contactDatabase!=null){
            this.contactDatabase.updateContact(sID ,displayName);
            this.flashContactList();
        }
    };

    this._Search = function( sID){
        if(this.m_contactList == null){
            return false;
        }
        for(var i = 0; i< this.m_contactList.length;i++){
            if(sID == this.m_contactList[i].id){
                return true;
            }
        }
        return false;
    };

    this.oContactListView = oContactListView;

    this.notifyDataSetChanged = function(){
        this.CleanUser();
        for(var i = 0; i < this.m_contactList.length;i++){
            this.AddUser(this.m_contactList[i].id);
        }
    };

    this.AddUser = function(sUser) {
        if(isEmpty(sUser)){
            return;
        }
        var oUserList = this.oContactListView;
        var sUserTxt = sUser;
        for (var i = 0; i < oUserList.rows.length; i++) {
            if (oUserList.rows[i].cells[1].textContent == sUserTxt) {
                return;
            }
        }
        var oRow = oUserList.insertRow(oUserList.rows.length);
        var oCell = oRow.insertCell(oRow.cells.length);
        oCell.className = "txt1";
        oCell.height = "24";
        oCell.width = "20";
        oCell.innerHTML = "<input  type='checkbox' name='contactListCheck' value='"+ sUserTxt + "'>";
        oCell = oRow.insertCell(oRow.cells.length);
        oCell.textContent = sUserTxt;
        oCell = oRow.insertCell(oRow.cells.length);
        oCell.innerHTML = "<input  type='button' name='Submit' onclick=pgContactStart('"+ sUserTxt + "') value='呼叫'>";
    };
    this.DeleteUser = function(sUserTxt) {
        
        var oUserList = this.oContactListView;
        
        for (var i = 0; i < oUserList.rows.length; i++) {
            if (oUserList.rows[i].cells[1].textContent == sUserTxt) {
                oUserList.deleteRow(i);
                return;
            }
        }
    };
    this.CleanUser = function() {
        var oUserList = this.oContactListView;
        while(oUserList.rows.length>0){
            oUserList.deleteRow(0);
        }
    };
   
}
module.exports = ContactManage;