'use strict';

var browserify = require('browserify');
var gulp = require('gulp');
var source = require('vinyl-source-stream');
var buffer = require('vinyl-buffer');
var uglify = require('gulp-uglify');
var sourcemaps = require('gulp-sourcemaps');
var log = require('gulplog');
var fs = require('fs');
function my_task(entries,src,dest,bMin){
    var b = browserify({
        entries: entries,
        debug: true
    });

   
    if(bMin){
        b.bundle()
        .pipe(source(src))
        .pipe(buffer())
        .pipe(sourcemaps.init({
            loadMaps: true
        }))
        // Add transformation tasks to the pipeline here.
        .pipe(uglify())
        .on('error', log.error)
        .pipe(sourcemaps.write('./'))
        .pipe(gulp.dest(dest));
    }else{
        b.bundle()
        .pipe(source(src))
        .pipe(buffer())
        .pipe(gulp.dest(dest));
    } 
}

function my_task1(standalone,src,dest){
    
    var bundle = browserify({ 
        standalone: standalone,
        debug: true
    });
    bundle.add(src);
    bundle.bundle(function (err, source) {
        if (err) {
            console.error(err);
        }
        fs.writeFileSync(dest, source);
    });
}


gulp.task('lib', function(done) {
    // set up the browserify instance on a task basis
    console.log("demo tast start");
    my_task1('pgLibConference2','./src/pgLibConference2','./dist/pgLibConference2.js',false);
    //my_task1('./src/pgLibConference2.js','pgLibConference2.js','./dist/',true);
    done();
});

gulp.task('demo',function(done){
    console.log("demo tast start");
    my_task1('Conference','./DemoConference2/src/Conference','./DemoConference2/dist/Conference.js');
    //my_task('./DemoConference2/src/LayoutMange.js','LayoutMange.js','./DemoConference2/dist/',false);
    my_task1('LayoutMange','./DemoConference2/src/LayoutMange','./DemoConference2/dist/LayoutMange.js');
    done();
});

gulp.task('default',function(done){
    // my_task1('pgLibConference2','./src/pgLibConference2','./dist/pgLibConference2.js',false);
    my_task1('Capture','./Demo/src/Capture','./Demo/dist/Capture.js');
    my_task1('Render','./Demo/src/Render','./Demo/dist/Render.js');
    //my_task('./DemoConference2/src/LayoutMange.js','LayoutMange.js','./DemoConference2/dist/',false);
    my_task1('UserDatabase','./Demo/src/UserDatabase','./Demo/dist/UserDatabase.js');
    my_task1('ContactManage','./Demo/src/ContactManage','./Demo/dist/ContactManage.js');
    done();
});