/*
 * Decompiled with CFR 0.152.
 */
package com.peergine.android.tunnel;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public class pgHttpApi {
    public static final int PG_ERR_Normal = 0;
    public static final int PG_ERR_System = 1;
    public static final int PG_ERR_BadParam = 2;
    public static final int PG_ERR_BadClass = 3;
    public static final int PG_ERR_BadMethod = 4;
    public static final int PG_ERR_BadObject = 5;
    public static final int PG_ERR_BadStatus = 6;
    public static final int PG_ERR_BadFile = 7;
    public static final int PG_ERR_BadUser = 8;
    public static final int PG_ERR_BadPass = 9;
    public static final int PG_ERR_NoLogin = 10;
    public static final int PG_ERR_Network = 11;
    public static final int PG_ERR_Timeout = 12;
    public static final int PG_ERR_Reject = 13;
    public static final int PG_ERR_Busy = 14;
    public static final int PG_ERR_Opened = 15;
    public static final int PG_ERR_Closed = 16;
    public static final int PG_ERR_Exist = 17;
    public static final int PG_ERR_NoExist = 18;
    public static final int PG_ERR_NoSpace = 19;
    public static final int PG_ERR_BadType = 20;
    public static final int PG_ERR_CheckErr = 21;
    public static final int PG_ERR_BadServer = 22;
    public static final int PG_ERR_BadDomain = 23;
    public static final int PG_ERR_NoData = 24;
    public static final int PG_ERR_Unknown = 255;
    public static final int TUNNEL_TYPE_Unknown = 0;
    public static final int TUNNEL_TYPE_PublicIP = 4;
    public static final int TUNNEL_TYPE_FullConeNAT = 5;
    public static final int TUNNEL_TYPE_HostRestrictNAT = 6;
    public static final int TUNNEL_TYPE_PortRestrictNAT = 7;
    public static final int TUNNEL_TYPE_SymmetricNAT = 8;
    public static final int TUNNEL_TYPE_Private = 12;
    public static final int TUNNEL_TYPE_NATLoop = 13;
    public static final int TUNNEL_TYPE_TCPForward = 16;
    public static final int TUNNEL_TYPE_HTTPForward = 17;
    public static final int TUNNEL_TYPE_PeerForward = 24;
    public static final int TUNNEL_TYPE_Offline = 65535;
    public static final int CONNECT_TYPE_Tcp = 0;
    public static final int CONNECT_TYPE_HttpProxy = 1;
    public static final int CONNECT_TYPE_HttpForward = 2;
    public static final int CONNECT_TYPE_Butt = 3;
    private int m_iTimeout = 2000;
    private String m_sHost = "127.0.0.1:17881";
    private NotifyCallback m_notifyCallback = null;
    private Handler m_handlerNotify = null;
    private HttpURLConnection m_urlCnntNotify = null;
    private Thread m_threadNotify = null;
    private boolean m_bThreadExit = false;

    public void SetHttpHost(String sHost) {
        if (!sHost.equals("")) {
            this.m_sHost = sHost;
        }
    }

    public void SetTimeout(int iTimeout) {
        if (iTimeout > 0) {
            this.m_iTimeout = iTimeout;
        }
    }

    public int DomainSet(String sPassCode) {
        String sURI = "domainset?passcode=" + sPassCode;
        String sRespText = this.HttpRequest("GET", this.m_sHost, sURI, "", this.m_iTimeout);
        if (sRespText == null) {
            return 1;
        }
        if (sRespText.indexOf("domainset:") != 0) {
            return 2;
        }
        try {
            JSONObject jsonObj = new JSONObject(sRespText.substring(10));
            int iErr = jsonObj.getInt("result");
            return iErr;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 2;
        }
    }

    public int DomainGet(ResDomainGet res) {
        String sURI = "domainget";
        String sRespText = this.HttpRequest("GET", this.m_sHost, sURI, "", this.m_iTimeout);
        if (sRespText == null) {
            return 1;
        }
        if (sRespText.indexOf("domainget:") != 0) {
            return 2;
        }
        try {
            JSONObject jsonObj = new JSONObject(sRespText.substring(10));
            res.sDomain = jsonObj.getString("domain");
            return 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 2;
        }
    }

    public int CommentSet(String sComment) {
        String sURI = "commentset?comment=" + sComment;
        String sRespText = this.HttpRequest("GET", this.m_sHost, sURI, "", this.m_iTimeout);
        if (sRespText == null) {
            return 1;
        }
        if (sRespText.indexOf("commentset:") != 0) {
            return 2;
        }
        try {
            JSONObject jsonObj = new JSONObject(sRespText.substring(11));
            int iErr = jsonObj.getInt("result");
            return iErr;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 2;
        }
    }

    public int CommentGet(ResCommentGet res) {
        String sURI = "commentget";
        String sRespText = this.HttpRequest("GET", this.m_sHost, sURI, "", this.m_iTimeout);
        if (sRespText == null) {
            return 1;
        }
        if (sRespText.indexOf("commentget:") != 0) {
            return 2;
        }
        try {
            JSONObject jsonObj = new JSONObject(sRespText.substring(11));
            res.sComment = jsonObj.getString("comment");
            return 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 2;
        }
    }

    public int TunnelSet(String sPassCode, String sComment) {
        String sURI = "tunnelset?passcode=" + sPassCode + "&comment=" + sComment;
        String sRespText = this.HttpRequest("GET", this.m_sHost, sURI, "", this.m_iTimeout);
        if (sRespText == null) {
            return 1;
        }
        if (sRespText.indexOf("domainset:") != 0) {
            return 2;
        }
        try {
            JSONObject jsonObj = new JSONObject(sRespText.substring(10));
            int iErr = jsonObj.getInt("result");
            return iErr;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 2;
        }
    }

    public int VersionGet(ResVersionGet res) {
        String sURI = "versionget";
        String sRespText = this.HttpRequest("GET", this.m_sHost, sURI, "", this.m_iTimeout);
        if (sRespText == null) {
            return 1;
        }
        if (sRespText.indexOf("versionget:") != 0) {
            return 2;
        }
        try {
            JSONObject jsonObj = new JSONObject(sRespText.substring(11));
            res.sVersion = jsonObj.getString("version");
            return 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 2;
        }
    }

    public int PeerInfoGet(String sPeerID, ResPeerInfoGet res) {
        String sURI = "peerinfoget?peerid=" + sPeerID;
        String sRespText = this.HttpRequest("GET", this.m_sHost, sURI, "", this.m_iTimeout);
        if (sRespText == null) {
            return 1;
        }
        if (sRespText.indexOf("peerinfoget:") != 0) {
            return 2;
        }
        try {
            JSONObject jsonObj = new JSONObject(sRespText.substring(12));
            int iErr = jsonObj.getInt("result");
            if (iErr != 0) {
                return iErr;
            }
            res.sPeerID = jsonObj.getString("peerid");
            res.iType = jsonObj.getInt("type");
            res.sAddrLocal = jsonObj.getString("addrlocal");
            res.sAddrRemote = jsonObj.getString("addrremote");
            res.sTunnelLocal = jsonObj.getString("tunnellocal");
            res.sTunnelRemote = jsonObj.getString("tunnelremote");
            res.sPrivRemote = jsonObj.getString("privremote");
            return 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 2;
        }
    }

    public int ConnectAdd(String sSession, String sPeerID, int iType, boolean bEncrypt, String sListenAddr, String sClientAddr, ResConnectAdd res) {
        if (iType >= 3) {
            return 2;
        }
        String sURI = "cnntadd?session=" + sSession + "&peerid=" + sPeerID + "&type=" + iType + "&encrypt=" + (bEncrypt ? 1 : 0) + "&listenaddr=" + sListenAddr + "&clientaddr=" + sClientAddr;
        String sRespText = this.HttpRequest("GET", this.m_sHost, sURI, "", this.m_iTimeout);
        if (sRespText == null) {
            return 1;
        }
        if (sRespText.indexOf("cnntadd:") != 0) {
            return 2;
        }
        try {
            JSONObject jsonObj = new JSONObject(sRespText.substring(8));
            int iErr = jsonObj.getInt("result");
            if (iErr != 0) {
                return iErr;
            }
            res.sClientAddr = jsonObj.getString("clientaddr");
            return 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 2;
        }
    }

    public int ConnectDelete(String sSession, String sPeerID, int iType, boolean bEncrypt, String sListenAddr, String sClientAddr) {
        if (iType >= 3) {
            return 2;
        }
        String sURI = "cnntdelete?session=" + sSession + "&peerid=" + sPeerID + "&type=" + iType + "&encrypt=" + (bEncrypt ? 1 : 0) + "&listenaddr=" + sListenAddr + "&clientaddr=" + sClientAddr;
        String sRespText = this.HttpRequest("GET", this.m_sHost, sURI, "", this.m_iTimeout);
        if (sRespText == null) {
            return 1;
        }
        if (sRespText.indexOf("cnntdelete:") != 0) {
            return 2;
        }
        try {
            JSONObject jsonObj = new JSONObject(sRespText.substring(11));
            int iErr = jsonObj.getInt("result");
            return iErr;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 2;
        }
    }

    public int ConnectQuery(String sPeerID, int iType, String sListenAddr, ResConnectQuery res) {
        if (iType >= 3) {
            return 2;
        }
        String sURI = "cnntquery?peerid=" + sPeerID + "&type=" + iType + "&listenaddr=" + sListenAddr;
        String sRespText = this.HttpRequest("GET", this.m_sHost, sURI, "", this.m_iTimeout);
        if (sRespText == null) {
            return 1;
        }
        if (sRespText.indexOf("cnntquery:") != 0) {
            return 2;
        }
        try {
            JSONObject jsonObj = new JSONObject(sRespText.substring(10));
            int iErr = jsonObj.getInt("result");
            if (iErr != 0) {
                return iErr;
            }
            res.sClientAddr = jsonObj.getString("clientaddr");
            return 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 2;
        }
    }

    public int ConnectLocalDelete(String sSession, String sClientAddr) {
        String sURI = "cnntlcldelete?session=" + sSession + "&clientaddr=" + sClientAddr;
        String sRespText = this.HttpRequest("GET", this.m_sHost, sURI, "", this.m_iTimeout);
        if (sRespText == null) {
            return 1;
        }
        if (sRespText.indexOf("cnntlcldelete:") != 0) {
            return 2;
        }
        try {
            JSONObject jsonObj = new JSONObject(sRespText.substring(14));
            int iErr = jsonObj.getInt("result");
            return iErr;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 2;
        }
    }

    public int ConnectLocalQuery(String sClientAddr, ResConnectLocalQuery res) {
        String sURI = "cnntlclquery?clientaddr=" + sClientAddr;
        String sRespText = this.HttpRequest("GET", this.m_sHost, sURI, "", this.m_iTimeout);
        if (sRespText == null) {
            return 1;
        }
        if (sRespText.indexOf("cnntlclquery:") != 0) {
            return 2;
        }
        try {
            JSONObject jsonObj = new JSONObject(sRespText.substring(13));
            int iErr = jsonObj.getInt("result");
            if (iErr != 0) {
                return iErr;
            }
            res.sPeerID = jsonObj.getString("peerid");
            res.iType = jsonObj.getInt("type");
            res.bEncrypt = jsonObj.getInt("encrypt") != 0;
            res.sListenAddr = jsonObj.getString("listenaddr");
            res.sClientAddr = jsonObj.getString("clientaddr");
            return 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 2;
        }
    }

    public int ServerRequest(String sData, ResServerRequest res) {
        String sURI = "userextend";
        String sRespText = this.HttpRequest("POST", this.m_sHost, sURI, sData, this.m_iTimeout);
        if (sRespText == null) {
            return 1;
        }
        if (sRespText.indexOf("userextend:") != 0) {
            return 2;
        }
        try {
            JSONObject jsonObj = new JSONObject(sRespText.substring(11));
            int iErr = jsonObj.getInt("result");
            if (iErr != 0) {
                return iErr;
            }
            res.sData = jsonObj.getString("data");
            return 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 2;
        }
    }

    public boolean ServerNotifyEnable(NotifyCallback callback) {
        try {
            this.m_notifyCallback = callback;
            this.m_handlerNotify = new Handler(){

                public void handleMessage(Message msg) {
                    Log.d((String)"pgHttpApi", (String)("handleMessage: Notify=" + msg.obj.toString()));
                    if (pgHttpApi.this.m_notifyCallback == null) {
                        return;
                    }
                    String sRespText = msg.obj.toString();
                    if (sRespText.indexOf("pushget:") != 0) {
                        return;
                    }
                    try {
                        JSONObject jsonObj = new JSONObject(sRespText.substring(8));
                        int iErr = jsonObj.getInt("result");
                        if (iErr != 0) {
                            return;
                        }
                        pgHttpApi.this.m_notifyCallback.OnNotify(jsonObj.getString("data"));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            };
            this.m_bThreadExit = false;
            this.m_threadNotify = new NotifyThread();
            this.m_threadNotify.start();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void ServerNotifyDisable() {
        try {
            this.m_bThreadExit = true;
            if (this.m_urlCnntNotify != null) {
                this.m_urlCnntNotify.disconnect();
                this.m_urlCnntNotify = null;
            }
            if (this.m_threadNotify != null) {
                this.m_threadNotify.join();
                this.m_threadNotify = null;
            }
            this.m_handlerNotify = null;
            this.m_notifyCallback = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String HttpRequest(String sMethod, String sHost, String sURI, String sBody, int iTimeout) {
        if (!sMethod.equals("GET") && !sMethod.equals("POST")) {
            Log.d((String)"pgHttpApi", (String)"HttpRequest: Invalid HTTP method.");
            return null;
        }
        try {
            RequestThread thread = new RequestThread(sMethod, sHost, sURI, sBody, iTimeout);
            thread.start();
            thread.join();
            String sRespText = thread.GetRespText();
            if (sRespText != null) {
                Log.d((String)"pgHttpApi", (String)("HttpRequest: resp=" + sRespText));
            }
            return sRespText;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void NotifyThreadProc() {
        while (!this.m_bThreadExit) {
            BufferedReader inBuf = null;
            try {
                try {
                    URL url = new URL("http://" + this.m_sHost + "/pushget");
                    this.m_urlCnntNotify = (HttpURLConnection)url.openConnection();
                    this.m_urlCnntNotify.setConnectTimeout(3000);
                    this.m_urlCnntNotify.setReadTimeout(3600000);
                    this.m_urlCnntNotify.setRequestMethod("GET");
                    this.m_urlCnntNotify.setUseCaches(false);
                    inBuf = new BufferedReader(new InputStreamReader(this.m_urlCnntNotify.getInputStream()));
                    String sTemp = "";
                    StringBuffer strBuffer = new StringBuffer();
                    while ((sTemp = inBuf.readLine()) != null) {
                        strBuffer.append(sTemp);
                    }
                    inBuf.close();
                    inBuf = null;
                    this.m_urlCnntNotify.disconnect();
                    this.m_urlCnntNotify = null;
                    Message msg = this.m_handlerNotify.obtainMessage();
                    msg.obj = strBuffer.toString();
                    this.m_handlerNotify.sendMessage(msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (inBuf != null) {
                            inBuf.close();
                        }
                        if (this.m_urlCnntNotify == null) continue;
                        this.m_urlCnntNotify.disconnect();
                        this.m_urlCnntNotify = null;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inBuf != null) {
                        inBuf.close();
                    }
                    if (this.m_urlCnntNotify != null) {
                        this.m_urlCnntNotify.disconnect();
                        this.m_urlCnntNotify = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (inBuf != null) {
                    inBuf.close();
                }
                if (this.m_urlCnntNotify == null) continue;
                this.m_urlCnntNotify.disconnect();
                this.m_urlCnntNotify = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface NotifyCallback {
        public void OnNotify(String var1);
    }

    class NotifyThread
    extends Thread {
        NotifyThread() {
        }

        @Override
        public void run() {
            pgHttpApi.this.NotifyThreadProc();
        }
    }

    class RequestThread
    extends Thread {
        private String m_sMethod = "";
        private String m_sHost = "";
        private String m_sURI = "";
        private String m_sBody = "";
        private int m_iTimeout = 0;
        private String m_sRespText = "";
        private boolean m_bSuccess = false;

        public RequestThread(String sMethod, String sHost, String sURI, String sBody, int iTimeout) {
            this.m_sMethod = sMethod;
            this.m_sHost = sHost;
            this.m_sURI = sURI;
            this.m_sBody = sBody;
            this.m_iTimeout = iTimeout;
            this.m_bSuccess = false;
        }

        @Override
        public void run() {
            BufferedReader inBuf = null;
            HttpURLConnection urlConnection = null;
            try {
                try {
                    URL url = new URL("http://" + this.m_sHost + "/" + this.m_sURI);
                    urlConnection = (HttpURLConnection)url.openConnection();
                    urlConnection.setConnectTimeout(this.m_iTimeout);
                    urlConnection.setReadTimeout(this.m_iTimeout);
                    urlConnection.setRequestMethod(this.m_sMethod);
                    urlConnection.setUseCaches(false);
                    if (this.m_sMethod.equals("POST")) {
                        urlConnection.setDoOutput(true);
                        urlConnection.getOutputStream().write(this.m_sBody.getBytes());
                    }
                    inBuf = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                    String sTemp = "";
                    StringBuffer strBuffer = new StringBuffer();
                    while ((sTemp = inBuf.readLine()) != null) {
                        strBuffer.append(sTemp);
                    }
                    inBuf.close();
                    inBuf = null;
                    urlConnection.disconnect();
                    urlConnection = null;
                    this.m_sRespText = strBuffer.toString();
                    this.m_bSuccess = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.m_bSuccess = false;
                    try {
                        if (inBuf != null) {
                            inBuf.close();
                        }
                        if (urlConnection != null) {
                            urlConnection.disconnect();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (inBuf != null) {
                        inBuf.close();
                    }
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public String GetRespText() {
            if (this.m_bSuccess) {
                return this.m_sRespText;
            }
            return null;
        }
    }

    public static class ResCommentGet {
        public String sComment = "";
    }

    public static class ResConnectAdd {
        public String sClientAddr = "";
    }

    public static class ResConnectLocalQuery {
        public String sPeerID = "";
        public int iType = 0;
        public boolean bEncrypt = false;
        public String sListenAddr = "";
        public String sClientAddr = "";
    }

    public static class ResConnectQuery {
        public String sClientAddr = "";
    }

    public static class ResDomainGet {
        public String sDomain = "";
    }

    public static class ResPeerInfoGet {
        public String sPeerID = "";
        public int iType = 0;
        public String sAddrLocal = "";
        public String sAddrRemote = "";
        public String sTunnelLocal = "";
        public String sTunnelRemote = "";
        public String sPrivRemote = "";
    }

    public static class ResServerRequest {
        public String sData = "";
    }

    public static class ResVersionGet {
        public String sVersion = "";
    }
}

