/****************************************************************
  copyright   : Copyright (C) 2013-2015, chenbichao,
              : All rights reserved.
              : www.pptun.com, www.peergine.com
              : 
  filename    : pgLibTunnel.h
  discription : 
  modify      : create, chenbichao, 2013/12/13
              :
			  : Modify, chenbichao, 2015/03/31
			  : 1.ÿAPIƼϡTunnelǰ׺SDKAPI
			  :
			  : Modify, chenbichao, 2015/04/29
			  : 1.pgTunnelSysInfolpszCfgFile
			  :
			  : Modify, chenbichao, 2016/04/26
			  : 1.pgTunnelSetNetCard
			  :
			  : Modify, chenbichao, 2016/11/14
			  : 1.к
			  :     pgTunnelVersionGet
			  :     pgTunnelDomainSet
			  :     pgTunnelDomainGet
			  :     pgTunnelCommentSet
			  :     pgTunnelCommentGet
			  :     pgTunnelTunnelSet
			  :     pgTunnelConnectAdd
			  :     pgTunnelConnectDelete
			  :     pgTunnelConnectQuery
			  :     pgTunnelConnectLocalDelete
			  :     pgTunnelConnectLocalQuery
			  :     pgTunnelUserExtend
			  :     pgTunnelPushGet
			  :
			  : Modify, chenbichao, 2017/02/18
			  : 1.pgTunnelStatusGet
			  : 
			  : Modify, chenbichao, 2017/06/13
			  : 1.pgTunnelSetCfgParam
			  :
			  : Modify, chenbichao, 2020/04/04
			  : 1.pgTunnelControl
			  :
			  : Modify, chenbichao, 2020/04/27
			  : 1.pgTunnelChannelSet
			  :
			  : Modify, chenbichao, 2023/03/22
			  : 1.pgTunnelPeerFwdCfg
			  :
			  : Modify, chenbichao, 2023/07/10
			  : 1.pgTunnelPeerAuthReply
			  :
*****************************************************************/
#ifndef _PG_LIB_TUNNEL_H
#define _PG_LIB_TUNNEL_H


#ifdef __cplusplus
extern "C" {
#endif


/**
 *  붨
 */
typedef enum tagPG_TUNNEL_ERROR_E {
	PG_TUNNEL_ERROR_OK = 0,             // ɹ
	PG_TUNNEL_ERROR_SYSTEM = -1,        // ϵͳ
	PG_TUNNEL_ERROR_BADPARAM = -2,      // ݵĲ
	PG_TUNNEL_ERROR_BADCLASS = -3,      // ЧĹ
	PG_TUNNEL_ERROR_BADMETHOD = -4,     // Чķ
	PG_TUNNEL_ERROR_BADOBJECT = -5,     // ЧĶ
	PG_TUNNEL_ERROR_BADSTATUS = -6,     // ״̬ȷ
	PG_TUNNEL_ERROR_BADFILE = -7,       // Чļ
	PG_TUNNEL_ERROR_BADUSER = -8,       // ûڡ
	PG_TUNNEL_ERROR_BADPASS = -9,       // 
	PG_TUNNEL_ERROR_NOLOGIN = -10,      // δ¼
	PG_TUNNEL_ERROR_NETWORK = -11,      // 
	PG_TUNNEL_ERROR_TIMEOUT = -12,      // ʱ
	PG_TUNNEL_ERROR_REJECT = -13,       // ܾ
	PG_TUNNEL_ERROR_BUSY = -14,         // ϵͳæ
	PG_TUNNEL_ERROR_OPENED = -15,       // ԴѾ
	PG_TUNNEL_ERROR_CLOSED = -16,       // ԴѾر
	PG_TUNNEL_ERROR_EXIST = -17,        // ԴѾ
	PG_TUNNEL_ERROR_NOEXIST = -18,      // Դ
	PG_TUNNEL_ERROR_NOSPACE = -19,      // ռ
	PG_TUNNEL_ERROR_BADTYPE = -20,      // Ч
	PG_TUNNEL_ERROR_CHECKERR = -21,     // У
	PG_TUNNEL_ERROR_BADSERVER = -22,    // Чķ
	PG_TUNNEL_ERROR_BADDOMAIN = -23,    // Ч
	PG_TUNNEL_ERROR_NODATA = -24,       // û
	PG_TUNNEL_ERROR_UNKNOWN = -255,     // δ֪
	PG_TUNNEL_ERROR_NOIMP = -256,       // ùûʵ֡
} PG_TUNNEL_ERROR_E;


/**
 *  P2Pͨ
 */
typedef enum tagPG_TUNNEL_CNNT_E {
	PG_TUNNEL_CNNT_Unknown = 0,            // δ֪ûм⵽

	PG_TUNNEL_CNNT_IPV4_Pub = 4,           // IPv4ַ
	PG_TUNNEL_CNNT_IPV4_NATConeFull = 5,   // ȫ׶NAT
	PG_TUNNEL_CNNT_IPV4_NATConeHost = 6,   // ׶NAT
	PG_TUNNEL_CNNT_IPV4_NATConePort = 7,   // ˿׶NAT
	PG_TUNNEL_CNNT_IPV4_NATSymmet = 8,     // ԳNAT

	PG_TUNNEL_CNNT_IPV4_Private = 12,      // ˽ֱ
	PG_TUNNEL_CNNT_IPV4_NATLoop = 13,      // ˽NAT

	PG_TUNNEL_CNNT_IPV4_TunnelTCP = 16,    // TCPv4ת
	PG_TUNNEL_CNNT_IPV4_TunnelHTTP = 17,   // HTTPv4ת

	PG_TUNNEL_CNNT_IPV4_PeerFwd = 24,      // P2Pڵת

	PG_TUNNEL_CNNT_IPV6_Pub = 32,          // IPv6ַ
	PG_TUNNEL_CNNT_IPV6_Local = 36,        // ˽IPv6ַ

	PG_TUNNEL_CNNT_IPV6_TunnelTCP = 40,    // TCPv6ת
	PG_TUNNEL_CNNT_IPV6_TunnelHTTP = 41,   // HTTPv6ת

	PG_TUNNEL_CNNT_P2P = 128,              // P2P
	PG_TUNNEL_CNNT_Local = 129,            // ˽
	PG_TUNNEL_CNNT_PeerForward = 130,      // ڵת
	PG_TUNNEL_CNNT_RelayForward = 131,     // мת

	PG_TUNNEL_CNNT_Offline = 65535,        // Զ˲

} PG_TUNNEL_CNNT_E;

/**
 *  ѯ״̬ѡ
 */
typedef enum tagPG_TUNNEL_GET_STA_E {
	PG_TUNNEL_GET_STA_LOGIN = 0,    // ѯ¼״̬
} PG_TUNNEL_GET_STA_E;

/**
 *  ¼״̬
 */
typedef enum tagPG_TUNNEL_STA_LOGIN_E {
	PG_TUNNEL_STA_LOGIN_SUCCESS = 0,       // ¼ɹ
	PG_TUNNEL_STA_LOGIN_CONFIG = 4,        // ļʧ
	PG_TUNNEL_STA_LOGIN_SYSINFO = 5,       // ϵͳϢ
	PG_TUNNEL_STA_LOGIN_RESOLUTION = 6,    // ʧ
	PG_TUNNEL_STA_LOGIN_BUILDACCOUNT = 7,  // ˺Ϣʧ
	PG_TUNNEL_STA_LOGIN_INITNODE = 8,      // ʼPeergine nodeʧ
	PG_TUNNEL_STA_LOGIN_INITFAILED = 9,    // ʼʧ
	PG_TUNNEL_STA_LOGIN_LOGINFAILED = 10,  // ͵¼ʧ
	PG_TUNNEL_STA_LOGIN_LOGOUTED = 11,     // ѾעԺԵ¼
	PG_TUNNEL_STA_LOGIN_REQUESTING = 16,   // ¼
	PG_TUNNEL_STA_LOGIN_TIMEOUT = 17,      // ¼ʱ
	PG_TUNNEL_STA_LOGIN_NETWORK = 18,      // ¼
	PG_TUNNEL_STA_LOGIN_BADUSER = 19,      // ¼û
	PG_TUNNEL_STA_LOGIN_BADPASS = 20,      // ¼
	PG_TUNNEL_STA_LOGIN_REJECT = 21,       // ¼󣨾ܾʣ
	PG_TUNNEL_STA_LOGIN_BUSY = 22,         // ¼󣨷æ
	PG_TUNNEL_STA_LOGIN_FAILED = 23,       // ¼¼ʧܣ
	PG_TUNNEL_STA_LOGIN_KICKOUT = 32,      // ûͻ
	PG_TUNNEL_STA_LOGIN_UNKNOWN = 255,     // δ֪״̬
	PG_TUNNEL_STA_LOGIN_EXTEND = 256,      // ûԶĿʼ
} PG_TUNNEL_STA_LOGIN_E;


/**
 *  ¼ID
 */
typedef enum tagPG_TUNNEL_EVENT_E {
	PG_TUNNEL_EVENT_EXIT = 0,                  // Tunnel SDK ˳
	PG_TUNNEL_EVENT_ERROR = 1,                 // ϵͳ󣬴ο'PG_TUNNEL_EVENT_ERROR_E'
	PG_TUNNEL_EVENT_LOGIN = 2,                 // ¼Ե¼Ľ
	PG_TUNNEL_EVENT_LOGOUT = 3,                // ע¼
	PG_TUNNEL_EVENT_KICKOUT = 4,               // ûIDͻ
	PG_TUNNEL_EVENT_PEER_UP = 5,               // Զ˵P2Pͨ
	PG_TUNNEL_EVENT_PEER_DOWN = 6,             // Զ˵P2PͨѶϿ
	PG_TUNNEL_EVENT_PEER_OFFLINE = 7,          // ԶѾ
	PG_TUNNEL_EVENT_CONNECT_ADD = 8,           // ӳ
	PG_TUNNEL_EVENT_CONNECT_DELETE = 9,        // ӳɾ
	PG_TUNNEL_EVENT_CONNECT_UP = 10,           // ӳ
	PG_TUNNEL_EVENT_CONNECT_DOWN = 11,         // ӳѶϿ
	PG_TUNNEL_EVENT_SERVER_PUSH = 12,          // P2PϢ
	PG_TUNNEL_EVENT_PEER_INFO = 13,            // P2PͨϢ
	PG_TUNNEL_EVENT_CONNECT_USED = 14,         // ӳĶ˿Ѿʹ
	PG_TUNNEL_EVENT_PEER_FWD_STATUS = 15,      // ڵת״̬Ϣ
	PG_TUNNEL_EVENT_PEER_FWD_STATISTIC = 16,   // ڵתĹͳϢ
	PG_TUNNEL_EVENT_PEER_FWD_STAT_USED = 17,   // ڵתͳϢ
	PG_TUNNEL_EVENT_SESSION_FAILED = 18,       // TCPỰʧ
	PG_TUNNEL_EVENT_PEER_AUTH_REQUEST = 19,    // Զӵ֤
	PG_TUNNEL_EVENT_PEER_AUTH_RESULT = 20,     // Զӵ֤
	PG_TUNNEL_EVENT_SESSION_STATISTIC = 21,    // TCPỰ״̬ͳϢ
	PG_TUNNEL_EVENT_PEER_STATISTIC = 22,       // P2PͨͳϢ
	PG_TUNNEL_EVENT_RELAY_ERROR = 23,          // мӵĴ
} PG_TUNNEL_EVENT_E;

/**
 *  ¼ 'PG_TUNNEL_EVENT_ERROR' ϱĴ
 */
typedef enum tagPG_TUNNEL_EVENT_ERROR_E {
	PG_TUNNEL_EVENT_ERROR_OK = 0,
	PG_TUNNEL_EVENT_ERROR_MEMORY_ALLOC = 1,          // ڴʧ
	PG_TUNNEL_EVENT_ERROR_SOCKET_ACCEPT = 2,         // acceptTCP clientʧ
	PG_TUNNEL_EVENT_ERROR_SOCKET_CREATE = 3,         // socketʧ
	PG_TUNNEL_EVENT_ERROR_SOCKET_OPTION = 4,         // socket optionʧ
	PG_TUNNEL_EVENT_ERROR_SOCKET_CONNECT = 5,        // connectTCP serverʧ
	PG_TUNNEL_EVENT_ERROR_SOCKET_GETADDR = 6,        // getsocknameȡsocket󶨵ĵַʧ
	PG_TUNNEL_EVENT_ERROR_SESSION_LIMIT = 7,         // TCPﵽMaxSess
	PG_TUNNEL_EVENT_ERROR_SESSION_RESOLUTION = 8,    // TCPʧ
	PG_TUNNEL_EVENT_ERROR_SESSION_FILTER = 9,        // TCPIPַ˹
	PG_TUNNEL_EVENT_ERROR_SOCKET_BIND = 10,          // bindsocketַʧ
} PG_TUNNEL_EVENT_ERROR_E;

/**
 *  ڵת״̬
 */
typedef enum tagPG_TUNNEL_PEER_FWD_STA_E {
	PG_TUNNEL_PEER_FWD_STA_DISABLE = 0,    // ڵתΪá
	PG_TUNNEL_PEER_FWD_STA_PAUSE = 1,      // ڵתΪͣΪʹ
	PG_TUNNEL_PEER_FWD_STA_IDLE = 2,       // ڵתΪãҵǰС
	PG_TUNNEL_PEER_FWD_STA_USED = 3,       // ڵתΪãҵǰЭת
} PG_TUNNEL_PEER_FWD_STA_E;

/**
 *  ƶID
 */
typedef enum tagPG_TUNNEL_CONTROL_E {
	PG_TUNNEL_CONTROL_LOGIN_NOW   = 0,     // ж˱ܣ¼
	PG_TUNNEL_CONTROL_RELOAD_CFG  = 1,     // װò
} PG_TUNNEL_CONTROL_E;

/**
 *  ͨͶ
 */
typedef enum tagPG_TUNNEL_CHANNEL_E {
	PG_TUNNEL_CHANNEL_AUTO  = 0,           // ԶӦP2P͸ͨRelayתͨĬϣ
	PG_TUNNEL_CHANNEL_P2P   = 1,           // ֻʹP2P͸ͨ
	PG_TUNNEL_CHANNEL_RELAY = 2,           // ǿʹRelayתͨ
} PG_TUNNEL_CHANNEL_E;

/**
 *  Ựķ
 */
typedef enum tagPG_TUNNEL_SESS_DIR_E {
	PG_TUNNEL_SESS_DIR_RECV  = 0,           // շ
	PG_TUNNEL_SESS_DIR_SEND  = 1,           // ͷ
} PG_TUNNEL_SESS_DIR_E;

/**
 * 汾Ϣṹ
 */
typedef struct tagPG_TUNNEL_VERSION_S {
	char szVersion[64];             // 汾Ϣ
} PG_TUNNEL_VERSION_S;

/**
 * ״̬Ϣṹ
 */
typedef struct tagPG_TUNNEL_STATUS_S {
	unsigned int uStatus;           // ״̬Ϣ'PG_TUNNEL_STA_LOGIN_E'öٶ
} PG_TUNNEL_STATUS_S;

/**
 * ƽṹ
 */
typedef struct tagPG_TUNNEL_DOMAIN_S {
	char szDomain[128];             // 
} PG_TUNNEL_DOMAIN_S;

/**
 * ͻ˵ṹ
 */
typedef struct tagPG_TUNNEL_COMMENT_S {
	char szComment[256];            // ͻ˵Ϣ
} PG_TUNNEL_COMMENT_S;

/**
 * P2PͨϢṹ
 */
typedef struct tagPG_TUNNEL_PEER_INFO_S {
	char szPeerID[128];             // Զ˵ûID
	unsigned int uType;             // P2Pͨͣö١PG_TUNNEL_CNNT_E塣
	char szAddrLocal[64];           // ˵ĵ¼ַ˿
	char szAddrRemote[64];          // Զ˵ĵ¼ַ˿
	char szTunnelLocal[64];         // ˵ַͨ˿
	char szTunnelRemote[64];        // Զ˵ַͨ˿
	char szPrivateRemote[64];       // Զ˵˽ַ˿
} PG_TUNNEL_PEER_INFO_S;

/**
 * ͻӵַ˿ڽṹ
 */
typedef struct tagPG_TUNNEL_CLIENT_ADDR_S {
	char szClientAddr[64];          // ˵Ŀͻӵַ˿
} PG_TUNNEL_CLIENT_ADDR_S;

/**
 * Ϣṹ
 */
typedef struct tagPG_TUNNEL_CONNECT_INFO_S {
	char szPeerID[128];             // Զ˵ûID
	unsigned int uType;             // ӵ
	unsigned int uEncrypt;          // Ƿ
	char szListenAddr[64];          // Զ˵ַ˿
	char szClientAddr[64];          // ˵Ŀͻ˵ַ˿
} PG_TUNNEL_CONNECT_INFO_S;

/**
 * Զݽṹ
 */
typedef struct tagPG_TUNNEL_DATA_S {
	unsigned int uSize;             // ָ 'szData' ĳȣֽڣ
	char szData[4];                 // ݵĻ
} PG_TUNNEL_DATA_S;

/**
 * ˵ûP2P IDṹ
 */
typedef struct tagPG_TUNNEL_SELF_S {
	char szSelf[128];               // ˵ûP2P ID
} PG_TUNNEL_SELF_S;


/**
 *  ־ص
 *
 *  uLevel[IN] ־
 *
 *  lpszOut[IN] ־
 */
typedef void (*TfnTunnelLogOut)(unsigned int uLevel, const char* lpszOut);


/**
 *  ¼ϱص
 *
 *  uEvent[IN] ¼IDοö'PG_TUNNEL_EVENT_E'
 *
 *  lpszParam[IN] ¼
 */
typedef void (*TfnTunnelEventProc)(unsigned int uEvent, const char* lpszParam);


/**
 *  עصӿڡ
 *
 *  ʽء
 *
 *  pfnEventProc [IN] ¼ϱصָ롣صԭͼTfnTunnelEventProc塣
 */
void pgTunnelCallbackSet(TfnTunnelEventProc pfnEventProc);


/**
 *   Peergine tunnel ģ
 *
 *  ʽء
 *
 *  lpszCfgFile[IN] ļ·
 *
 *  lpszSysInfo[IN] 豸ϵͳϢpgTunnelSysInfo()ȡ
 *      ʽ"(DevID){1234}(MacAddr){}(CpuMHz){1}(MemSize){1}(BrwVer){}(OSVer){}(OSSpk){}(OSType){}"
 *      ڻֵСDevIDǱģǿѡġ
 *
 *  lpvParam[IN] Զ
 *
 *  pfnLogOut[IN] ־صָ롣صԭͼTfnTunnelLogOut塣
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelStart(const char* lpszCfgFile, const char* lpszSysInfo,
	void* lpvParam, TfnTunnelLogOut pfnLogOut);


/**
 *  ֹͣ Peergine tunnel ģ顣
 * 
 *  ʽء
 *
 */
void pgTunnelStop();


/**
*  ֱļ
*       ע⣺pgTunnelStart()֮ǰá
*       ΪļһЩеϢЩ²ϣûļݡ
*       ֳ£Եô˺ֱӰļñ浽SDKڲУҪṩһļ
*
*  ʽء
*
*  lpszCfgParam[IN] ò(ʽݲοļ˵)
*
*  ֵö١PG_TUNNEL_ERROR_EĶ
*/
int pgTunnelSetCfgParam(const char* lpszCfgParam);


/**
 *  ȡǰ豸ϵͳϢ(Щ豸ϵͳûʵ)
 * 
 *  ʽء
 *
 *  lpszCfgFile[IN] ļ·(ļȡɳе·LOGļʱļдɳĿ¼)
 *
 *  lpszInfo[OUT] ϵͳϢĻ
 *
 *  uSize[IN] lpszInfoĳȡ
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelSysInfo(const char* lpszCfgFile, char* lpszInfo, unsigned int uSize);


/**
 *  ָʹõ(LINUXϵͳʵ֡)
 *       ע⣺pgTunnelStart()֮ǰá
 * 
 *  ʽء
 *
 *  lpszNetCard[IN] ָӿƣ磺eth0, eth1, ...
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelSetNetCard(const char* lpszNetCard);


/**
 *  ȡpgLibTunnel SDKİ汾
 * 
 *  ʽء
 *
 *  lpstVersion[OUT] 汾Ϣ'PG_TUNNEL_VERSION_S'塣
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelVersionGet(PG_TUNNEL_VERSION_S* lpstVersion);


/**
 *  ȡ¼P2P״̬
 * 
 *  ʽء
 *
 *  uOption[IN] ѡ'PG_TUNNEL_GET_STA_E'塣
 *
 *  lpstStatus[OUT] ״̬Ϣ'PG_TUNNEL_STATUS_S'塣
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelStatusGet(unsigned int uOption, PG_TUNNEL_STATUS_S* lpstStatus);


/**
 *  ʶ룬ѱͻ˼뵽ʶӦû
 * 
 *  ʽȴִв
 *
 *  lpszPasscode[IN] ʶ롣
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelDomainSet(const char* lpszPasscode);


/**
 *  ȡͻ˵ǰơ
 * 
 *  ʽȴִв
 *
 *  lpstDomain[OUT] ƣ'PG_TUNNEL_DOMAIN_S'塣
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelDomainGet(PG_TUNNEL_DOMAIN_S* lpstDomain);


/**
 *  ÿͻ˵˵
 * 
 *  ʽȴִв
 *
 *  lpszComment[IN] ͻ˵˵
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelCommentSet(const char* lpszComment);


/**
 *  ȡͻ˵˵
 * 
 *  ʽȴִв
 *
 *  lpstComment[OUT] ͻ˵˵Ϣ'PG_TUNNEL_COMMENT_S'塣
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelCommentGet(PG_TUNNEL_COMMENT_S* lpstComment);


/**
 *  ÿͻ˵ʶ˵
 * 
 *  ʽȴִв
 *
 *  lpszPasscode[IN] ͻ˵ʶ롣
 *
 *  lpszComment[IN] ͻ˵˵Ϣ
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelTunnelSet(const char* lpszPasscode, const char* lpszComment);


/**
 *  ȡͻ˺ָûIDԶ̿ͻ֮P2PͨϢ
 * 
 *  ʽȴִв
 *
 *  lpszPeerID[IN] Զ˿ͻ˵ûID
 *
 *  lpstPeerInfo[OUT] P2PͨϢ'PG_TUNNEL_PEER_INFO_S'塣
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelPeerInfoGet(const char* lpszPeerID, PG_TUNNEL_PEER_INFO_S* lpstPeerInfo);


/**
 *  ͻ˺ָûIDԶ̿ͻ֮һӡ
 *        ӳɹرӳĿͻӵַ˿Ϣ
 * 
 *  ʽȴִв
 *
 *  lpszSession[IN] ¼ỰID
 *      ѡַֻP2P˿¼Ự֤ʱҪЧֵ
 *
 *  lpszPeerID[IN] Զ˿ͻ˵ûID
 *
 *  uType[IN] ӵͣ0:ΪTCPӣ1ΪHTTP
 *
 *  uEncrypt[IN] Ƿܣ0Ϊܣ1Ϊܡ
 *
 *  lpszListenAddr[IN] ԶTCPַ˿ڡ
 *
 *  lpszClientAddr[IN] ӳĿͻӵַ˿ڡ
 *
 *  lpstClientAddr[OUT] ͻӵַ˿Ϣ'PG_TUNNEL_CLIENT_ADDR_S'塣
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelConnectAdd(const char* lpszSession, const char* lpszPeerID,
	unsigned int uType, unsigned int uEncrypt, const char* lpszListenAddr,
	const char* lpszClientAddr, PG_TUNNEL_CLIENT_ADDR_S* lpstClientAddr);


/**
 *  ɾһӡ
 * 
 *  ʽȴִв
 *
 *  lpszSession[IN] ¼ỰID
 *      ѡַֻP2P˿¼Ự֤ʱҪЧֵ
 *
 *  lpszPeerID[IN] Զ˿ͻ˵ûID
 *
 *  uType[IN] ӵͣ0:ΪTCPӣ1ΪHTTP
 *
 *  uEncrypt[IN] Ƿܣ0Ϊܣ1Ϊܡ
 *
 *  lpszListenAddr[IN] ԶTCPַ˿ڡ
 *
 *  lpszClientAddr[IN] ӳĿͻӵַ˿ڡ
 *      ַɾɡlpszPeerIDuTypeuEncryptlpszListenAddr4ƥӡ
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelConnectDelete(const char* lpszSession, const char* lpszPeerID,
	unsigned int uType, unsigned int uEncrypt, const char* lpszListenAddr,
	const char* lpszClientAddr);


/**
 *  ȡһӵıӳĿͻӵַ˿ڡ
 * 
 *  ʽȴִв
 *
 *  lpszPeerID[IN] Զ˿ͻ˵ûID
 *
 *  uType[IN] ӵͣ0:ΪTCPӣ1ΪHTTP
 *
 *  uEncrypt[IN] Ƿܣ0Ϊܣ1Ϊܡ
 *
 *  lpszListenAddr[IN] ԶTCPַ˿ڡ
 *
 *  lpstClientAddr[OUT] ӳĿͻӵַ˿Ϣ'PG_TUNNEL_CLIENT_ADDR_S'塣
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelConnectQuery(const char* lpszPeerID, unsigned int uType, unsigned int uEncrypt,
	const char* lpszListenAddr, PG_TUNNEL_CLIENT_ADDR_S* lpstClientAddr);


/**
 *  ݱӳĿͻӵַ˿Ϣɾһӡ
 * 
 *  ʽȴִв
 *
 *  lpszSession[IN] ¼ỰID
 *      ѡַֻP2P˿¼Ự֤ʱҪЧֵ
 *
 *  lpszClientAddr[IN] ӳĿͻӵַ˿ڡ
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelConnectLocalDelete(const char* lpszSession, const char* lpszClientAddr);


/**
 *  ݱӳĿͻӵַ˿ϢȡһӵȫϢ
 * 
 *  ʽȴִв
 *
 *  lpszClientAddr[IN] ӳĿͻӵַ˿ڡ
 *
 *  lpstConnectInfo[OUT] ӵȫϢ'PG_TUNNEL_CONNECT_INFO_S'塣
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelConnectLocalQuery(const char* lpszClientAddr, PG_TUNNEL_CONNECT_INFO_S* lpstConnectInfo);


/**
 *  ԶP2PշӦ
 * 
 *  ʽȴִв
 *
 *  lpszRequestData[IN] ͸ݡ
 *
 *  lpstReplyData[OUT] յķݡ
 *
 *  uTimeout[IN] ȴʱʱ䣨룩
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelUserExtend(const char* lpszRequestData, PG_TUNNEL_DATA_S* lpstReplyData, unsigned int uTimeout);


/**
 *  P2P·Ϣ
 * 
 *  ʽͻ˵ĻѾƵϢݣػϢݡ
 *            ͻ˵ĻлûƵϢݣȴP2PϢݡ
 *
 *  lpstPushData[OUT] յϢݡ
 *
 *  uTimeout[IN] ȴʱʱ䣨룩
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelPushGet(PG_TUNNEL_DATA_S* lpstPushData, unsigned int uTimeout);


/**
 *  ȡ˵ûID
 * 
 *  ʽȴִв
 *
 *  lpstSelf[OUT] յ˵ûID
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelSelfGet(PG_TUNNEL_SELF_S* lpstSelf);


/**
 *  ȡӵȫϢ
 * 
 *  ʽȴִв
 *
 *  uIndex [IN] ţ0, 1, 2, 3, 4, ...
 *
 *  lpstConnectInfo[OUT] ӵȫϢ'PG_TUNNEL_CONNECT_INFO_S'塣
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelConnectEnum(unsigned int uIndex, PG_TUNNEL_CONNECT_INFO_S* lpstConnectInfo);


/**
 *  ִжĿƲ
 * 
 *  ʽء
 *
 *  uCtrl [IN] ƶID'PG_TUNNEL_CONTROL_E'塣
 *
 *  lpszParam [IN] ƶĲԤԺʹá
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelControl(unsigned int uCtrl, const char* lpszParam);


/**
 *  Զͨŵͨ
 * 
 *  ʽء
 *
 *  lpszPeerID[IN] Զ˿ͻ˵ûID
 *
 *  uType [IN] ͨͣ'PG_TUNNEL_CHANNEL_E'塣
 *
 *  lpszParam [IN] ԤԺʹá
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelChannelSet(const char* lpszPeerID, unsigned int uType, const char* lpszParam);


/**
 *  ̬ýڵתĲ
 * 
 *  ʽء
 *
 *  iSpeed [IN] ڵΪתڵ㡣
 *      С0ıò0תĴ(ֽ/)0ת
 *
 *  iGate [IN] ڵ㴥ֹͣЭתôֵ(ֽ/)
 *      С0ıòڻ0ֵָĬϣ262144
 *
 *  iUse [IN] ڵǷʹڵΪתڵ㡣
 *      С0ıò0ǣ0Ĭϣ1
 *
 *  iMaxSess [IN] ڵЭתỰ
 *      С0ıòڻ0ָỰĬϣ3
 *
 *  lpszOption [IN] ѡԤԺʹá
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelPeerFwdCfg(int iSpeed, int iGate, int iUse, int iMaxSess, const char* lpszOption);


/**
 *  Զӵ֤Ϣ
 * 
 *  ʽء
 *
 *  lpszPeerID[IN] Զ˿ͻ˵ûID
 *
 *  lpszAuthInfo [IN] ֤Ϣ
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelPeerAuthSet(const char* lpszPeerID, const char* lpszAuthInfo);


/**
 *  ӦԶӵ֤
 * 
 *  ʽء
 *
 *  lpszHandle[IN] ֤ 'PG_TUNNEL_EVENT_PEER_AUTH_REQUEST' ¼еhandleֵ
 *
 *  uErrCode [IN] ӦĴ룬ͨ 'PG_TUNNEL_EVENT_PEER_AUTH_RESULT' ¼ظˡ
 *                ֤ʹֵеһ
 *                  PG_TUNNEL_ERROR_OK (0)֤ɹ
 *                  -PG_TUNNEL_ERROR_REJECT (13)ܾǰ'-'Ϊţ
 *                  -PG_TUNNEL_ERROR_BADUSER (8)ûǰ'-'Ϊţ
 *                  -PG_TUNNEL_ERROR_BADPASS (9)ǰ'-'Ϊţ
 *
 *  lpszParam [IN] ѡͨ 'PG_TUNNEL_EVENT_PEER_AUTH_RESULT' ¼ظˡ
 *
 *  ֵö١PG_TUNNEL_ERROR_EĶ
 */
int pgTunnelPeerAuthReply(const char* lpszHandle, unsigned int uErrCode, const char* lpszParam);


#ifdef __cplusplus
}
#endif


#endif // _PG_LIB_TUNNEL_H
