/****************************************************************
  copyright   : Copyright (C) 2011-2012, chenbichao,
                All rights reserved.
  filename    : pgSrcWin.h
  discription : 
  modify      : create, chenbichao, 2012/10/10

*****************************************************************/
#ifndef _PG_SRC_WIN_H
#define _PG_SRC_WIN_H

#include "winsvc.h"

void pgSvcWinLog(const char* lpszFmt, ...);

class CPGSvcWin  
{
public:
	void Run();
	void Init(LPCTSTR lpszSvcName);

	BOOL IsInstalled(LPCTSTR lpszSvcName);
    BOOL Install(LPCTSTR lpszSvcName, LPCTSTR lpszSvcCmmt, BOOL bAutoStart);
    BOOL Uninstall(LPCTSTR lpszSvcName);

	BOOL Start(LPCTSTR lpszSvcName);

	void SetServiceStatus(DWORD dwState);

	CPGSvcWin();
	virtual ~CPGSvcWin();

public:
    virtual void OnExit() = 0;
    virtual void OnRun() = 0;

private:
	void ServiceMain(DWORD dwArgc, LPTSTR* lpszArgv);
	void Handler(DWORD dwOpcode);

private:
	static void WINAPI _ServiceMain(DWORD dwArgc, LPTSTR* lpszArgv);
    static void WINAPI _Handler(DWORD dwOpcode);

public:
    TCHAR m_szSvcName[256];
    SERVICE_STATUS_HANDLE m_hSvcStatus;
    SERVICE_STATUS m_stStatus;
	BOOL m_bService;
};


#endif //_PG_SRC_WIN_H
